package com.cftech.mp.custservice.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.mp.custservice.model.MultiCustservice;
import com.cftech.mp.custservice.service.MultiCustserviceService;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * 微信多客服Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String MULTICUSTSERVICE_VIEW = "mp:multiCustservice:view"
 * 查看:public static final String MULTICUSTSERVICE_EDIT = "mp:multiCustservice:edit"
 *
 * @author strive
 * @date: 2017-04-19 16:15
 */
@Slf4j
@Controller
@RequestMapping("/a/multiCustservice")
public class MultiCustserviceController {

    public static final String MULTICUSTSERVICE_VIEW = "mp:multiCustservice:view";
    public static final String MULTICUSTSERVICE_EDIT = "mp:multiCustservice:edit";

    @Autowired
    private MultiCustserviceService multiCustserviceService;


    //列表页面
    @RequiresPermissions(value = MULTICUSTSERVICE_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "multiCustservice/multiCustservicelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = MULTICUSTSERVICE_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            MultiCustservice multiCustservice = multiCustserviceService.fetchById(id);
            model.addAttribute("data", multiCustservice);
        }
        return "multiCustservice/multiCustserviceform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = MULTICUSTSERVICE_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(MultiCustservice multiCustservice, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (multiCustservice != null && multiCustservice.getId() != null) {
                multiCustservice.setUpdateBy(UserUtils.getUser().getId());
                multiCustserviceService.update(multiCustservice);
                rtnJson.put("errorNo", 0);
            } else {
                multiCustservice.setAccountsId(accountsId);
                multiCustservice.setDelFlag(false);
                multiCustservice.setAccountsId(UserUtils.getmpaccounts(request));
                multiCustservice.setCreateBy(UserUtils.getUser().getId());
                multiCustservice.setUpdateBy(UserUtils.getUser().getId());
                multiCustserviceService.save(multiCustservice);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = MULTICUSTSERVICE_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, MultiCustservice multiCustservice, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<MultiCustservice> list = multiCustserviceService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = multiCustserviceService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = MULTICUSTSERVICE_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            multiCustserviceService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
