package com.cftech.member.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Cond;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.member.dao.MemberMapper;
import com.cftech.member.model.Member;
import com.cftech.member.model.MemberDto;
import com.cftech.member.service.MemberService;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.workshop.model.Workshop;
import com.cftech.workshop.workshop.service.WorkshopService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author lisw
 * @date: 2017-08-24 17:31
 */
@Service("memberService")
public class MemberServiceImpl extends GenericServiceImpl<Member> implements MemberService {

    @Autowired
    @Qualifier("memberMapper")
    private MemberMapper memberMapper;

    @Autowired
    private WorkshopService workshopService;

    @Override
    public GenericDao<Member> getGenericMapper() {
        return memberMapper;
    }

    @Override
    public List<Member> fetchSearchByPageServer(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return memberMapper.fetchSearchByPageServer(params);
    }

    @Override
    public int countServer(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return memberMapper.countServer(params);
    }

    @Override
    public List<MemberDto> selectmemberDto(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return memberMapper.selectmemberDto(params);
    };

    @Override
    public int selectmemberDtoCount (Conds conds){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return memberMapper.selectmemberDtoCount(params);
    };

    @Override
    public void updateworkshop(Member member,String invitcode) {
        if(member!=null){
            Conds conds1 = new Conds();
            conds1.equal("invitcode",invitcode);
            Sort sort1 = new Sort("create_time", OrderType.DESC);
            List<Workshop> list1 = workshopService.selectworkshop(conds1,sort1,0,0);
            if(list1!=null&&list1.size()>0){
                Workshop workshop = list1.get(0);
                if(member.getSurname().equals(workshop.getSurname())&&member.getName().equals(workshop.getFirst_name())&&member.getPhone().equals("")){
                    member.setPhone(workshop.getPhone());
                    memberMapper.save(member); //注册成功会员表里面添加一条数据
                }else{
                    memberMapper.save(member); //注册成功会员表里面添加一条数据
                }
            }
            //把memberuid 插入到预导入名单表里面
            if(StringUtils.isNoneBlank(invitcode)){
                Conds conds = new Conds();
                conds.equal("invitcode",invitcode);
                Sort sort = new Sort("create_time", OrderType.DESC);
                List<Workshop> list = workshopService.selectworkshop(conds,sort,0,0);
                if(list!=null&&list.size()>0){
                    for(Workshop workshop : list){
                        workshop.setMember_uid(member.getMember_uid());
                        workshopService.update(workshop);
                    }
                }
            }
        }
    }
}