package com.cftech.member.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lisw
 * @date: 2017-09-13 14:04
 */
@Data
public class MemberTags implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 标签码 */
    @ExportConfig(value = "标签码", width = 100)
    private String tagCode;
    /* 标签名称 */
    @ExportConfig(value = "标签名称", width = 100)
    private String tagName;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /**
     * 标签所绑定卡券ID
     */
    private String cardNames;

    public MemberTags() {
        this.delFlag = false;
        this.status = "0";
    }

}