package com.cftech.cms.column.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.column.model.Column;
import com.cftech.cms.column.service.ColumnService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * CMS栏目管理Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String COLUMN_VIEW = "qy:column:view"
 * 查看:public static final String COLUMN_EDIT = "qy:column:edit"
 *
 * @author lisw
 * @date: 2017-05-03 09:24
 */
@Slf4j
@Controller
@RequestMapping("/a/column")
public class ColumnController {

    public static final String COLUMN_VIEW = "qy:column:view";
    public static final String COLUMN_EDIT = "qy:column:edit";

    @Autowired
    private ColumnService columnService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = COLUMN_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET, RequestMethod.POST})
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "column/columnlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = COLUMN_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Column column = columnService.fetchById(id);
            model.addAttribute("data", column);
        }
        return "column/columnform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = COLUMN_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(Column column, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (column != null && column.getId() != null) {
                column.setUpdateBy(UserUtils.getUser().getId());
                columnService.update(column);
                rtnJson.put("errorNo", 0);
            } else {
                column.setNumber(codingruleUtils.getNumber(accountsId, Column.class.getName()));
                column.setAccountsId(accountsId);
                column.setDelFlag(false);
                column.setAccountsId(UserUtils.getmpaccounts(request));
                column.setCreateBy(UserUtils.getUser().getId());
                column.setUpdateBy(UserUtils.getUser().getId());
                columnService.save(column);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }


    @RequestMapping(value = "getfetchDataChild",method = {RequestMethod.POST})
    @ResponseBody
    public com.alibaba.fastjson.JSONObject getfetchDataChild(HttpServletRequest request){
        com.alibaba.fastjson.JSONObject rtnJson = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONArray array = new com.alibaba.fastjson.JSONArray();
        Long accountsid = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("sort", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsid);
        List<Column> list = columnService.fetchSearchByPage(conds, sort, 0, 0);


        com.alibaba.fastjson.JSONObject t = new com.alibaba.fastjson.JSONObject();
        t.put("id", 0);
        t.put("pId", -1);
        t.put("name", "栏目");
        t.put("open",true);
        array.add(t);
        for(Column column : list){
            com.alibaba.fastjson.JSONObject tmp = new com.alibaba.fastjson.JSONObject();
            tmp.put("id",column.getId());
            tmp.put("pId",0);
            tmp.put("name",column.getName());
            array.add(tmp);
        }
        rtnJson.put("aaData", array);
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = COLUMN_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Column column, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(column.getNumber())) {
            conds.like("number", column.getNumber());
        }
        if (!StringUtils.isEmpty(column.getName())) {
            conds.like("name", column.getName());
        }
        if (!StringUtils.isEmpty(column.getImg())) {
            conds.like("img", column.getImg());
        }
        if (!StringUtils.isEmpty(column.getRemarks())) {
            conds.like("remarks", column.getRemarks());
        }
        Sort sort = new Sort("sort", OrderType.DESC);

        List<Column> list = columnService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = columnService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = COLUMN_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            columnService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
