package com.cftech.cms.cfarticle.web;

import com.cftech.cms.cfarticle.model.Cfarticle;
import com.cftech.cms.cfarticle.service.CfarticleService;
import com.cftech.cms.column.model.Column;
import com.cftech.cms.column.service.ColumnService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.core.util.StringUtils;
import com.cftech.mp.article.service.ArticleService;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by faye on 2017/10/10.
 */
@RestController
@RequestMapping(value = "/mobile/auth/cfarticle")
@Slf4j
public class MobileCfArticleController {

    @Autowired
    private ColumnService columnService;

    @Autowired
    private ArticleService articleService;

    @Autowired
    private CfarticleService cfarticleService;
    /**
     *获取栏目列表
     */
    @RequestMapping(value = "/getCategoryData", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String getCategoryData(Long accountsId,int pageNo,int pageSize){
        JSONObject rtnJson=new JSONObject();
        try{
            rtnJson.put("errorNo",0);
            Conds conds = new Conds();
            conds.equal("del_flag", Constants.DEL_FLAG_0);
            conds.equal("accounts_id", accountsId);
            Sort sort = new Sort("sort", OrderType.DESC);
            List<Column> list = columnService.fetchSearchByPage(conds, sort, pageNo*pageSize, pageSize);
            rtnJson.put("data",list);
        }catch (Exception e){
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","服务器异常！");
            log.error("获取栏目列表"+e.getMessage());
        }
        return rtnJson.toString();
    }

    /**
     *获取文章列表
     */
    @RequestMapping(value = "/getArticleData", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String getArticleData(Long accountsId,int pageNo,int pageSize,Long categoryId,String name){
        JSONObject rtnJson=new JSONObject();
        try{
            rtnJson.put("errorNo",0);
            Conds artConds=new Conds();
            if(categoryId==0){
                Conds conds = new Conds();
                conds.equal("del_flag", Constants.DEL_FLAG_0);
                conds.equal("accounts_id", accountsId);
                Sort sort = new Sort("sort", OrderType.DESC);
                List<Column> categoryList = columnService.fetchSearchByPage(conds, sort, pageNo*pageSize, pageSize);
                rtnJson.put("category",categoryList);
               if(categoryList!=null&&categoryList.size()>0){
                   categoryId=categoryList.get(0).getId();
               }
            }
            artConds.equal("t.column",categoryId);
            artConds.equal("t.del_flag", Constants.DEL_FLAG_0);
            artConds.equal("t.accounts_id", accountsId);
            if (!org.springframework.util.StringUtils.isEmpty(name)) {
                artConds.like("t.title", name);
            }
            Sort artSort = new Sort("t.create_time", OrderType.DESC);
            List<Cfarticle> list = cfarticleService.fetchSearchByPage(artConds, artSort, pageNo*pageSize, pageSize);
            rtnJson.put("article",list);
        }catch (Exception e){
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","服务器异常！");
            log.error("获取栏目列表"+e.getMessage());
        }
        return rtnJson.toString();
    }

    /**
     *获取文章详情
     */
    @RequestMapping(value = "/getArticleDetail", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String getArticleDetail(Long id){
        JSONObject rtnJson=new JSONObject();
        try{
           Cfarticle cfarticle=cfarticleService.fetchById(id);
           rtnJson.put("errorNo",0);
           rtnJson.put("data",cfarticle);
           if(cfarticle!=null){
               Conds reviewConds =new Conds();
               reviewConds.equal("r.accounts_id",cfarticle.getAccountsId());
               reviewConds.equal("r.module_type",0);
               reviewConds.equal("r.entity_id",cfarticle.getId());
               int reviewCount=cfarticleService.countReview(reviewConds);
               rtnJson.put("reviewCount",reviewCount);
           }
        }catch (Exception e){
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","服务器异常！");
            log.error("获取栏目列表"+e.getMessage());
        }
        return rtnJson.toString();
    }
}
