package com.cftech.cms.cfarticle.service.impl;

import com.cftech.cms.cfarticle.dao.CfarticleMapper;
import com.cftech.cms.cfarticle.model.Cfarticle;
import com.cftech.cms.cfarticle.model.CfarticleColumnDto;
import com.cftech.cms.cfarticle.service.CfarticleService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CMS文章管理ServiceImpl
 *
 * @author lisw
 * @date: 2017-05-03 10:51
 */
@Service("cfarticleService")
public class CfarticleServiceImpl extends GenericServiceImpl<Cfarticle> implements CfarticleService {

    @Autowired
    @Qualifier("cfarticleMapper")
    private CfarticleMapper cfarticleMapper;

    @Override
    public GenericDao<Cfarticle> getGenericMapper() {
        return cfarticleMapper;
    }

    @Override
    public List<CfarticleColumnDto> fetchSearchByPageTemp(Conds conds, Sort sort, int page, int pageSize,Long specialId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("specialId",specialId);
        return cfarticleMapper.fetchSearchByPageTemp(params);
    }

    @Override
    public int countTemp(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return cfarticleMapper.countTemp(params);
    }

    @Override
    public List<Cfarticle> fetchSearchByPageInOrder(Conds conds, String articles) {
        Map<String,Object> params = new HashMap<String, Object>();
        params.put("conds",conds);
        params.put("articles",articles);
        return cfarticleMapper.fetchSearchByPageInOrder(params);
    }

    @Override
    public int countReview(Conds conds) {
        Map<String,Object> params = new HashMap<String, Object>();
        params.put("conds",conds);
        return cfarticleMapper.countReview(params);
    }
}