package com.cftech.order.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.cftech.core.poi.ExportConfig;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 订单管理
 *
 * @author Licc
 * @date: 2020-10-10 14:20
 */

public class Order extends OrderDetail implements Serializable {

    /* 主键id */
    private Long id;
    /* 订单编码 */
    @ExportConfig(value = "订单编码", width = 100, showLevel = 1)
    private String orderCode;
    /* 咨询单id */
    @ExportConfig(value = "咨询单id", width = 100, showLevel = 1)
    private Long consultId;
    /* 咨询单编码 */
    @ExportConfig(value = "咨询单编码", width = 100, showLevel = 1)
    private String number;
    /* 所属会员id */
    @ExportConfig(value = "所属会员id", width = 100, showLevel = 1)
    private Long memberId;
    /* 客服id */
    @ExportConfig(value = "客服id", width = 100, showLevel = 1)
    private Long serviceId;
    /* 医生id */
    @ExportConfig(value = "医生id", width = 100, showLevel = 1)
    private Long doctorId;
    /* 用户所属公众号id */
    @ExportConfig(value = "用户所属公众号id", width = 100, showLevel = 1)
    private String openid;
    /* 付款状态 0未付款 1已付款 */
    @ExportConfig(value = "付款状态 0未付款 1已付款", width = 100, showLevel = 1)
    private Long payStatus;
    /* 付款金额 */
    @ExportConfig(value = "付款金额", width = 100, showLevel = 1)
    private Double payAmount;
    /* 订单金额 */
    @ExportConfig(value = "订单金额", width = 100, showLevel = 1)
    private Double orderAmount;
    /* 商品最终金额 */
    @ExportConfig(value = "商品最终金额", width = 100, showLevel = 1)
    private Double totalAmount;
    /* 付款时间 */
    @ExportConfig(value = "付款时间", width = 100, showLevel = 1)
    private Date payTime;
    /* 交易号 支付宝/第三方平台 返回订单号 */
    @ExportConfig(value = "交易号 支付宝/第三方平台 返回订单号", width = 100, showLevel = 1)
    private String tradeNo;
    /* 卖家备注 */
    @ExportConfig(value = "卖家备注", width = 100, showLevel = 1)
    private String remarks;
    /* 订单取消原因 */
    @ExportConfig(value = "订单取消原因", width = 100, showLevel = 1)
    private String orderCancel;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private Long confirm;

    private String courierNumber;

    /* 产品编码 */
    private String productNumber;
    /* 产品名称 */
    private String productName;
    /* 收货地址 */
    private String address;

    private Long productId;

    private List<ProductVO> list;

    public Order() {
        this.delFlag = false;
        this.status = "0";
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getOrderCode() {
        return orderCode;
    }

    @Override
    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Long getConsultId() {
        return consultId;
    }

    public void setConsultId(Long consultId) {
        this.consultId = consultId;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Long getServiceId() {
        return serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Long getDoctorId() {
        return doctorId;
    }

    public void setDoctorId(Long doctorId) {
        this.doctorId = doctorId;
    }

    @Override
    public String getOpenid() {
        return openid;
    }

    @Override
    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public Long getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Long payStatus) {
        this.payStatus = payStatus;
    }

    public Double getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(Double payAmount) {
        this.payAmount = payAmount;
    }

    public Double getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(Double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public Double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getOrderCancel() {
        return orderCancel;
    }

    public void setOrderCancel(String orderCancel) {
        this.orderCancel = orderCancel;
    }

    @Override
    public Long getAccountsId() {
        return accountsId;
    }

    @Override
    public void setAccountsId(Long accountsId) {
        this.accountsId = accountsId;
    }

    @Override
    public boolean isDelFlag() {
        return delFlag;
    }

    @Override
    public void setDelFlag(boolean delFlag) {
        this.delFlag = delFlag;
    }

    @Override
    public String getStatus() {
        return status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Long getCreateBy() {
        return createBy;
    }

    @Override
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Override
    public Long getUpdateBy() {
        return updateBy;
    }

    @Override
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Long getConfirm() {
        return confirm;
    }

    public void setConfirm(Long confirm) {
        this.confirm = confirm;
    }

    public String getCourierNumber() {
        return courierNumber;
    }

    public void setCourierNumber(String courierNumber) {
        this.courierNumber = courierNumber;
    }

    public String getProductNumber() {
        return productNumber;
    }

    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    public String getProductName() {
        if (list == null) {
            return null;
        }
        List<String> collect = this.list.stream().map(x -> x.getProductName()).collect(Collectors.toList());
        return StringUtils.join(collect, ";");
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<ProductVO> getList() {
        return list;
    }

    public void setList(List<ProductVO> list) {
        this.list = list;
    }


}