package com.cftech.workshop.agenda.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.workshop.agenda.model.*;
import com.cftech.workshop.agenda.dao.AgendaMapper;
import com.cftech.workshop.agenda.service.AgendaService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.workshop.meeting.dao.MeetingMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-06-29 14:32
 */
@Service("agendaService")
public class AgendaServiceImpl extends GenericServiceImpl<Agenda> implements AgendaService {

    @Autowired
    @Qualifier("agendaMapper")
    private AgendaMapper agendaMapper;

    @Autowired
    private MeetingMapper meetingMapper;

    @Override
    public GenericDao<Agenda> getGenericMapper() {
        return agendaMapper;
    }

    @Override
    public List<AgendaDto> selectagendascor(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return agendaMapper.selectagendascor(params);
    }

    @Override
    public  List<AgendaDto> selectagendascore1(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return  agendaMapper.selectagendascore1(params);
    }

    @Override
    public List<Agenda> selectagendacustomiz(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return agendaMapper.selectagendacustomiz(params);
    }

    @Override
    public List<AgendaSpeech> selectagendaspeech(Conds conds,Sort sort){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("sort",sort);
        return agendaMapper.selectagendaspeech(params);
    };

    @Override
    public List<AgendaCustomiz> agendaCustomizs(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return  agendaMapper.agendaCustomizs(params);
    };

    @Override
    public int agendaCustomizcount(Conds conds){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return agendaMapper.agendaCustomizcount(params);
    };

    @Override
    public List<AgendaDtoB> selectspeechb(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return agendaMapper.selectspeechb(params);
    }

}