//import com.cftech.common.promotionstock.model.AfterStockDto;
//import com.cftech.common.promotionstock.model.EvalityNumberDto;
//import com.cftech.common.promotionstock.model.GrantDetailDto;
//import com.cftech.common.promotionstock.model.PStockStatisticalDto;
//import com.cftech.common.promotionstock.service.PromotionStockService;
//import com.cftech.common.typeappform.model.TypeAppForm;
//import com.cftech.core.scope.OrderType;
//import com.cftech.core.sql.Conds;
//import com.cftech.core.sql.Sort;
//import com.cftech.core.util.Constants;
//import com.cftech.core.util.StringUtils;
//import lombok.val;
//import org.apache.poi.hssf.usermodel.HSSFWorkbook;
//import org.apache.poi.ss.usermodel.Cell;
//import org.apache.poi.ss.usermodel.CellStyle;
//import org.apache.poi.ss.usermodel.Row;
//import org.apache.poi.ss.usermodel.Sheet;
//import org.apache.poi.ss.util.CellRangeAddress;
//import org.junit.Test;
//import org.junit.runner.RunWith;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.test.context.ContextConfiguration;
//import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
//
//import java.io.FileOutputStream;
//import java.io.IOException;
//import java.math.BigDecimal;
//import java.text.NumberFormat;
//import java.util.*;
//import java.util.stream.Collectors;
//
///**
// * @author lisw
// * @program schaeffler
// * @description 促销品统计报表
// * @createDate 2020-01-17 10:00:29
// **/
//@RunWith(SpringJUnit4ClassRunner.class)
//@ContextConfiguration(locations={"classpath*:applicationContext*.xml"})
//public class NewStatisticalExportUtil {
//
//    private StatisticalCommonExportUtil statisticalCommonExportUtil = null;
//
//    private String startDate = null;
//
//    private String endDate = null;
//
//    @Autowired
//    private PromotionStockService promotionStockService;
//
//
//    @Test
//    public void test() throws IOException {
//        String fileName = "促销品统计报表";
//        startDate = "2019-1-1";
//        endDate = "2020-5-1";
//        // 创建excel文件对象
//        HSSFWorkbook wb = new HSSFWorkbook();
//        statisticalCommonExportUtil = new StatisticalCommonExportUtil(wb);
//        // 创建sheet
//        Sheet sheetManagerStock = wb.createSheet("管理员库存统计");
//        Sheet sheetSupplierStock = wb.createSheet("供应商发货统计");
//        Sheet sheetDeptStatistical = wb.createSheet("按部门领用统计");
//        Sheet sheetUseStatistical = wb.createSheet("按用途领用统计");
//        Sheet sheetEvaluateStatistical = wb.createSheet("评价信息统计");
//        Sheet sheetPromotionStatistical = wb.createSheet("促销品发放明细");
//
//        String[] managerArr = rtnSheet1(startDate, endDate);
//        String[] supplierArr = rtnSheet2(startDate, endDate);
//        //第一个sheet数据填充
//        String[] sheetManagerTitles = new String[]{"管理员库存统计", "管理员本月发货明细", "管理员本月发货金额", "管理员本月剩余库存", "管理员本月剩余库存金额"};
//        createContentRow(sheetManagerStock, sheetManagerTitles, managerArr);
//        //合并单元格
//        sheetManagerMerged(sheetManagerStock);
//        //第二个sheet
//        String[] sheetSupplierTitles = new String[]{"供应商发货统计", "供应商发货明细", "供应商发货金额", "供应商物流金额", "需支付给供应商的金额"};
//        createContentRow(sheetSupplierStock, sheetSupplierTitles, supplierArr);
//        //合并单元格
//        sheetManagerMerged(sheetSupplierStock);
//
//        //第三个sheet
//        String[] deptsAndUseTitles = new String[]{"月度部门领用统计", "领用明细（按降序排列）", "领用金额", "占总量百分比"};
//        List<GrantDetailDto> grantDetailDtoDepts = promotionStockService.deptGrantDetails(startDate, endDate);
//        Map<String, List<GrantDetailDto>> corpIdMap =
//                grantDetailDtoDepts.stream().collect(Collectors.groupingBy(GrantDetailDto::getDname));
//        createContentRowDeptAndUse(sheetDeptStatistical, deptsAndUseTitles, corpIdMap);
//        //第四个sheet
//        List<GrantDetailDto> grantDetailDtoUses = promotionStockService.useGrantDetails(startDate, endDate);
//        Map<String, List<GrantDetailDto>> corpIdUseMap =
//                grantDetailDtoUses.stream().collect(Collectors.groupingBy(GrantDetailDto::getUname));
//        createContentRowDeptAndUse(sheetUseStatistical, deptsAndUseTitles, corpIdUseMap);
//        //第五个sheet
//        sheetQualityContent(sheetEvaluateStatistical);
//        //第六个sheet
//        sheetLogStaictical(sheetPromotionStatistical);
//        //所有sheet首行合并单元格
//        for(int i = 0;i<wb.getNumberOfSheets();i++){
//            createHeaderFirsts(wb.getSheetAt(i));
//        }
//        wb.write(new FileOutputStream("/Users/lisw/work/table2.xls"));
//    }
//
//    //获取内容并解析sheet1,管理员库存统计
//    public String[] rtnSheet1(String startDate, String endDate) {
//        String[] managers = new String[5];
//        //获取管理员的发货明细
//        List<GrantDetailDto> managerGrantList = promotionStockService.managerGrantDetail(startDate, endDate);
//        if (!managerGrantList.isEmpty()) {
//            StringBuffer managerGrantBuffer = new StringBuffer();
//            BigDecimal managerGrantTotalPrice = new BigDecimal("0");
//            for (GrantDetailDto grantDetailDto : managerGrantList) {
//                managerGrantBuffer.append(grantDetailDto.getItemname() + "*" + grantDetailDto.getGrantCount() + ";" + statisticalCommonExportUtil.getLineStr());
//                managerGrantTotalPrice = managerGrantTotalPrice.add(grantDetailDto.getTotalPrice()).setScale(2, BigDecimal.ROUND_HALF_UP);
//            }
//            managers[1] = managerGrantBuffer.toString();
//            managers[2] = managerGrantTotalPrice.toString();
//        }
//        //获取管理员的剩余库存明细
//        List<AfterStockDto> afterStockDtos = promotionStockService.managerAfterStock(startDate, endDate);
//        if (!afterStockDtos.isEmpty()) {
//            StringBuffer afterStockBuffer = new StringBuffer();
//            BigDecimal managerAfterStockTotalPrice = new BigDecimal("0");
//            for (AfterStockDto afterStockDto : afterStockDtos) {
//                afterStockBuffer.append(afterStockDto.getItemname() + "*" + afterStockDto.getAfterChangeStock() + ";" + statisticalCommonExportUtil.getLineStr());
//                managerAfterStockTotalPrice = managerAfterStockTotalPrice.add(afterStockDto.getTotalPrice()).setScale(2, BigDecimal.ROUND_HALF_UP);
//            }
//            managers[3] = afterStockBuffer.toString();
//            managers[4] = managerAfterStockTotalPrice.toString();
//        }
//        return managers;
//    }
//
//    //获取内容并极细sheet2，供应商库存统计
//    public String[] rtnSheet2(String startDate, String endDate) {
//        String[] suppliers = new String[5];
//        //供应商发货总金额
//        BigDecimal grantBigDecimal = new BigDecimal("0");
//        //解析供应商发货明细
//        List<GrantDetailDto> grantDetailDtos = promotionStockService.supplierGrantDetail(startDate, endDate);
//        if (!grantDetailDtos.isEmpty()) {
//            StringBuffer supplierGrantBuffer = new StringBuffer();
//            for (GrantDetailDto grantDetailDto : grantDetailDtos) {
//                supplierGrantBuffer.append(grantDetailDto.getItemname() + "*" + grantDetailDto.getGrantCount() + ";" + statisticalCommonExportUtil.getLineStr());
//                grantBigDecimal = grantBigDecimal.add(grantDetailDto.getTotalPrice()).setScale(2, BigDecimal.ROUND_HALF_UP);
//            }
//            suppliers[1] = supplierGrantBuffer.toString();
//            suppliers[2] = grantBigDecimal.toString();
//        }
//
//        //供应商物流金额
//        BigDecimal logisticsPrice = promotionStockService.supplierLogisticsPrice(startDate, endDate);
//        if (logisticsPrice == null) {
//            logisticsPrice = new BigDecimal("0");
//        }
//
//        suppliers[3] = logisticsPrice.toString();
//        suppliers[4] = grantBigDecimal.add(logisticsPrice).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
//        return suppliers;
//    }
//
//
//
//    //每个sheet的第一列绘制
//    public void createHeaderFirsts(Sheet sheet) {
//        sheet.setDefaultColumnWidth(30);
//        Row row = sheet.createRow(0);
//        row.setHeight(statisticalCommonExportUtil.getRowHeight());
//        Cell cell = row.createCell(0);
//        CellStyle cellStyle = statisticalCommonExportUtil.getGrey25CellStyle();
//        cellStyle.setAlignment(CellStyle.ALIGN_LEFT); // 水平布局：居左
//        cell.setCellValue(startDate + "至" + endDate + sheet.getSheetName());
//        cell.setCellStyle(cellStyle);
//        for (int i = 1; i <= 30; i++) {
//            Cell cellTemp = row.createCell(i);
//            cellTemp.setCellValue("");
//            cellTemp.setCellStyle(cellStyle);
//        }
//        CellRangeAddress region = new CellRangeAddress(0, 0, 0, 30);
//        sheet.addMergedRegion(region);
//    }
//
//    //创建内容区前两个sheet（管理员库存统计，供应商发货统计）的表头
//    public void createContentRow(Sheet sheet, String[] titles, String[] content) {
//        Row row = sheet.createRow(1);
//        row.setHeight(statisticalCommonExportUtil.getRowHeight());
//        for (int i = 0; i < titles.length; i++) {
//            Cell cell = row.createCell(i);
//            if (i == titles.length - 1) {
//                cell.setCellStyle(statisticalCommonExportUtil.getGoldCellStyle());
//            } else {
//                cell.setCellStyle(statisticalCommonExportUtil.getGreenCellStyle());
//            }
//            cell.setCellValue(titles[i]);
//        }
//        Row rowContent = sheet.createRow(2);
//        rowContent.setHeight(statisticalCommonExportUtil.getRowHeight());
//        for (int i = 0; i < content.length; i++) {
//            Cell cell = rowContent.createCell(i);
//            cell.setCellStyle(statisticalCommonExportUtil.getGenterateCellStyle());
//            cell.setCellValue(content[i]);
//        }
//    }
//
//    //创建内容区第三个sheet（按部门纬度进行统计发放明细），第四个sheet（按用途纬度进行统计发放明细）
//    public void createContentRowDeptAndUse(Sheet sheet, String[] titles, Map<String, List<GrantDetailDto>> corpIdMap) {
//        Row row = sheet.createRow(1);
//        row.setHeight(statisticalCommonExportUtil.getRowHeight());
//        for (int i = 0; i < titles.length; i++) {
//            Cell cell = row.createCell(i);
//            cell.setCellStyle(statisticalCommonExportUtil.getGreenCellStyle());
//            cell.setCellValue(titles[i]);
//        }
//
//        Set<String> keys = corpIdMap.keySet();
//        Map<String, Integer> allGrantCountMap = new HashMap<>();
//        //所有部门加在一起的发货金额
//        BigDecimal bigDecimalAllTotalPrice = new BigDecimal("0");
//        Row rowAll = sheet.createRow(2);
//        int index = 3;
//        for (String key : keys) {
//            Row rowdept = sheet.createRow(index++);
//            List<GrantDetailDto> grantDetailDtos = corpIdMap.get(key);
//            StringBuffer stringBuffer = new StringBuffer();
//            BigDecimal sligeBigDecimal = new BigDecimal("0");//本部门总的发货金额
//            for (GrantDetailDto grantDetailDto : grantDetailDtos) {
//                sligeBigDecimal =sligeBigDecimal.add(grantDetailDto.getTotalPrice()).setScale(2, BigDecimal.ROUND_HALF_UP);
//                Integer count = grantDetailDto.getGrantCount();
//                String itemName = grantDetailDto.getItemname();
//                if (allGrantCountMap.containsKey(grantDetailDto.getItemname())) {
//                    Integer oldcount = allGrantCountMap.get(itemName);
//                    oldcount += count;
//                    allGrantCountMap.put(itemName, oldcount);
//                } else {
//                    allGrantCountMap.put(itemName, count);
//                }
//                stringBuffer.append(itemName + "*" + count + statisticalCommonExportUtil.getLineStr());
//
//            }
//            bigDecimalAllTotalPrice =bigDecimalAllTotalPrice.add(sligeBigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
//            for (int i = 0; i < 4; i++) {
//                Cell cell = rowdept.createCell(i);
//                cell.setCellStyle(statisticalCommonExportUtil.getGenterateCellStyle());
//                switch (i) {
//                    case 0:
//                        cell.setCellValue(key);
//                        break;
//                    case 1:
//                        cell.setCellValue(stringBuffer.toString());
//                        break;
//                    case 2:
//                        cell.setCellValue(sligeBigDecimal.toString());
//                        break;
//                }
//            }
//        }
//        if (allGrantCountMap.size() > 0) {//汇总内容填充
//
//            allGrantCountMap = sortByValue2(allGrantCountMap, 0);
//            Set<String> allKeys = allGrantCountMap.keySet();
//            StringBuffer allGrantDetailsBuffer = new StringBuffer();
//            for (String allKey : allKeys) {
//                allGrantDetailsBuffer.append(allKey + "*" + allGrantCountMap.get(allKey) + statisticalCommonExportUtil.getLineStr());
//            }
//            for (int i = 0; i < 4; i++) {
//                Cell cell = rowAll.createCell(i);
//                cell.setCellStyle(statisticalCommonExportUtil.getGenterateCellStyle());
//                switch (i) {
//                    case 0:
//                        cell.setCellValue("月度领用总统计（所有）");
//                        break;
//                    case 1:
//                        cell.setCellValue(allGrantDetailsBuffer.toString());
//                        break;
//                    case 2:
//                        cell.setCellValue(bigDecimalAllTotalPrice.toString());
//                        break;
//                    case 3:
//                        cell.setCellValue("100%");
//                        break;
//                }
//            }
//        }
//
//        //计算百分比
//        int rows = sheet.getLastRowNum();
//        for (int p = 3; p <=rows; p++) {
//            Row rowTemp = sheet.getRow(p);
//            Cell cell = rowTemp.getCell(2);
//            BigDecimal price = new BigDecimal(cell.getStringCellValue());//占用金额
//            price = price.divide(bigDecimalAllTotalPrice,2,BigDecimal.ROUND_HALF_UP);
//            NumberFormat percent = NumberFormat.getPercentInstance();
//            percent.setMaximumFractionDigits(2);
//            String percentPrice = percent.format(price.doubleValue());
//            Cell cellPrecent = rowTemp.getCell(3);
//            cellPrecent.setCellValue(percentPrice);
//            cellPrecent.setCellStyle(statisticalCommonExportUtil.getGenterateCellStyle());
//        }
//    }
//
//    //创建第五个sheet，评价统计
//    private void sheetQualityContent(Sheet sheet){
//        EvalityNumberDto managerEvalityNumberDto = promotionStockService.managerEvaluate(startDate,endDate);
//        EvalityNumberDto applyEvalityNumberDto = promotionStockService.applyEvaluate(startDate,endDate);
//        Integer managerConfirm = promotionStockService.managerConfirm(startDate,endDate);
//        String [] qualityTitles= new String[] {"管理员提交评价订单数量","","申请人提交评价订单数量","","管理员确认收货订单数量",""};
//        List<String []> mapList = new ArrayList<>();
//        String[] titleMap = new String[]{"月度评价统计","整体评价","促销品质量","物流服务"};
//        mapList.add(titleMap);
//        String[] managerMap = new String[]{"管理员","","",""};
//        String[]  applyMap = new String[]{"申请人","","",""};
//        if(managerEvalityNumberDto!=null){
//            qualityTitles[1] = String.valueOf(managerEvalityNumberDto.getCount());
//            Integer allEvaluateCount = managerEvalityNumberDto.getAllEvaluateCount();
//            Integer qualityEvaluateCount = managerEvalityNumberDto.getQualityEvaluateCount();
//            Integer logisticsEvaluateCount = managerEvalityNumberDto.getLogisticsEvaluateCount();
//            managerMap[1]=allEvaluateCount!=null?allEvaluateCount.toString():"0";
//            managerMap[2]=qualityEvaluateCount!=null?qualityEvaluateCount.toString():"0";
//            managerMap[3]=logisticsEvaluateCount!=null?logisticsEvaluateCount.toString():"0";
//        }
//        if(applyEvalityNumberDto!=null){
//            qualityTitles[3] = String.valueOf(applyEvalityNumberDto.getCount());
//            Integer allEvaluateCount = applyEvalityNumberDto.getAllEvaluateCount();
//            Integer qualityEvaluateCount = applyEvalityNumberDto.getQualityEvaluateCount();
//            Integer logisticsEvaluateCount = applyEvalityNumberDto.getLogisticsEvaluateCount();
//            applyMap[1] = allEvaluateCount!=null?allEvaluateCount.toString():"0";
//            applyMap[2] = qualityEvaluateCount!=null?qualityEvaluateCount.toString():"0";
//            applyMap[3] = logisticsEvaluateCount!=null?logisticsEvaluateCount.toString():"0";
//        }
//        mapList.add(managerMap);
//        mapList.add(applyMap);
//        qualityTitles[5] = String.valueOf(managerConfirm);
//        Row row =  sheet.createRow(1);
//        row.setHeight(statisticalCommonExportUtil.getRowHeight());
//        for(int i =0;i<6;i++){
//            Cell cell = row.createCell(i);
//            if(i%2==0){
//                cell.setCellStyle(statisticalCommonExportUtil.getGreenCellStyle());
//                cell.setCellValue(qualityTitles[i]);
//            }else{
//                cell.setCellStyle(statisticalCommonExportUtil.getGenterateCellStyle());
//                cell.setCellValue(qualityTitles[i]);
//            }
//        }
//
//        //创建空行，占位行高
//        Row rowEmpty = sheet.createRow(2);
//        rowEmpty.setHeight(statisticalCommonExportUtil.getRowHeight());
//
//        for (int i = 0; i < mapList.size(); i++) {
//            String [] array = mapList.get(i);
//            Row createRow = sheet.createRow(3+i);
//            createRow.setHeight(statisticalCommonExportUtil.getRowHeight());
//            for (int k = 0; k < array.length; k++) {
//                Cell cell = createRow.createCell(k);
//                cell.setCellValue(array[k]==null?"":array[k]);
//                if(i==0 || k==0){
//                    cell.setCellStyle(statisticalCommonExportUtil.getGreenCellStyle());
//                }else{
//                    cell.setCellStyle(statisticalCommonExportUtil.getGenterateCellStyle());
//                }
//            }
//        }
//    }
//
//    //第六个sheet,明细信息
//    private void sheetLogStaictical(Sheet sheet){
//        String [] sheetPromotionStaticticalTitle = new String[]{"序号","申请单号","Legal Entity","部门","成本中心","发放状态","发货方","发货明细",
//                "发货物流信息","供应商发货物流金额","管理员发货备注","发货总金额","管理员发货金额","供应商发货金额","需支付给供应商的金额"
//        };
//        Row rowFirst = sheet.createRow(1);
//        rowFirst.setHeight(statisticalCommonExportUtil.getRowHeight());
//        for (int i = 0; i <sheetPromotionStaticticalTitle.length ; i++) {
//            Cell cell = rowFirst.createCell(i);
//            cell.setCellStyle(statisticalCommonExportUtil.getGreenCellStyle());
//            cell.setCellValue(sheetPromotionStaticticalTitle[i]);
//        }
//        Conds conds = new Conds();
//        conds.equal("appform.del_flag", Constants.DEL_FLAG_0);
//        List<TypeAppForm> typeAppForms = promotionStockService.fetchSearchByPageByAppform(conds,startDate,endDate);
//        if(!typeAppForms.isEmpty()){
//            for (int i = 0; i < typeAppForms.size(); i++) {
//                Row dataRow = sheet.createRow(i+2);
//                TypeAppForm typeAppForm = typeAppForms.get(i);
//                statisticalCommonExportUtil.createCell(0,typeAppForm.getSerialNumber(),dataRow);
//                statisticalCommonExportUtil.createCell(1,typeAppForm.getNumber(),dataRow);
//                statisticalCommonExportUtil.createCell(2,typeAppForm.getLegalEntity(),dataRow);
//                statisticalCommonExportUtil.createCell(3,typeAppForm.getDname(),dataRow);
//                statisticalCommonExportUtil.createCell(4,typeAppForm.getCostCenter(),dataRow);
//                statisticalCommonExportUtil.createCell(5,typeAppForm.getIssuingStateName(),dataRow);
//                String items = typeAppForm.getItems();
//                String grantSourceName = "";//发放方
//                String logistics = ""; //物流信息
//                String grantDetails = "";//发放信息
//                //发货总金额
//                String sumGrantPrice = null;
//                switch (typeAppForm.getGrantSource()){
//                    case "0"://仅供应商
//                        if(StringUtils.isNotBlank(typeAppForm.getDisLogisticsOrderInfo())){
//                            logistics+=typeAppForm.getDisLogisticsOrderInfo();
//                        }
//                        grantDetails = statisticalCommonExportUtil.parseItemsSupplierJSON(items);
//                        grantSourceName="仅供应商";
//                        sumGrantPrice=typeAppForm.getDisTotalPrice();
//                        break;
//                    case "1"://仅管理员
//                        if(StringUtils.isNotBlank(typeAppForm.getLogisticsOrderInfo())){
//                            logistics+=typeAppForm.getLogisticsOrderInfo();
//                        }
//                        grantDetails = statisticalCommonExportUtil.parseItemsManagerJSON(items);
//                        grantSourceName="仅管理员";
//                        sumGrantPrice=typeAppForm.getTotalPrice();
//                        break;
//                    case "2"://供应商加管理员
//                        grantSourceName="供应商+管理员";
//                        String managerName = " 管理员:";
//                        String supplierName = " 供应商:";
//                        if(StringUtils.isNotBlank(typeAppForm.getLogisticsOrderInfo())){
//                            logistics+=managerName+typeAppForm.getLogisticsOrderInfo();
//                        }
//                        if(StringUtils.isNotBlank(typeAppForm.getDisLogisticsOrderInfo())){
//                            logistics+=supplierName+typeAppForm.getDisLogisticsOrderInfo();
//                        }
//                        grantDetails=managerName+statisticalCommonExportUtil.parseItemsManagerJSON(items)+statisticalCommonExportUtil.getLineStr();
//                        grantDetails+=supplierName+statisticalCommonExportUtil.parseItemsSupplierJSON(items);
//                        BigDecimal disBig = new BigDecimal(typeAppForm.getDisTotalPrice());
//                        BigDecimal managerBig = new BigDecimal(typeAppForm.getTotalPrice());
//                        sumGrantPrice=disBig.add(managerBig).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
//                        break;
//                }
//                statisticalCommonExportUtil.createCell(6,grantSourceName,dataRow);
//                statisticalCommonExportUtil.createCell(7,grantDetails,dataRow);
//                statisticalCommonExportUtil.createCell(8,logistics,dataRow);
//                statisticalCommonExportUtil.createCell(9,typeAppForm.getDisLogisticsPrice(),dataRow);
//                statisticalCommonExportUtil.createCell(10,typeAppForm.getManagerSubmitRemarks(),dataRow);
//                statisticalCommonExportUtil.createCell(11,sumGrantPrice,dataRow);
//                statisticalCommonExportUtil.createCell(12,typeAppForm.getTotalPrice(),dataRow);
//                statisticalCommonExportUtil.createCell(13,typeAppForm.getDisTotalPrice(),dataRow);
//                //需要支付给供应商的金额，发放金额+物流金额
//                if(StringUtils.isNotBlank(typeAppForm.getDisLogisticsPrice())){
//                    BigDecimal bigLogisticsDecimal = new BigDecimal(typeAppForm.getDisLogisticsPrice());
//                    BigDecimal bigGrantDecimal = new BigDecimal(typeAppForm.getDisTotalPrice());
//                    BigDecimal res = bigGrantDecimal.add(bigLogisticsDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
//                    statisticalCommonExportUtil.createCell(14,res,dataRow);
//                }else{
//                    statisticalCommonExportUtil.createCell(14,"",dataRow);
//                }
//            }
//        }
//    }
//
//
//
//    //合并管理员库存统计，供应商发货统计两个sheet中需要合并的单元格
//    private void sheetManagerMerged(Sheet sheet) {
//        CellRangeAddress regionTitle = new CellRangeAddress(1, 2, 0, 0);
//        sheet.addMergedRegion(regionTitle);
//    }
//
//
//
//    //Map排序
//
//    /**
//     * @param map
//     * @param flag 1正序 0 倒序
//     * @param <K>
//     * @param <V>
//     * @return
//     */
//    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue2(Map<K, V> map, int flag) {
//
//        if (flag == 1) {
//            return map.entrySet().stream().sorted((o1, o2) -> o1.getValue().compareTo(o2.getValue())).map(entry -> {
//                Map<K, V> result = new LinkedHashMap<>();
//                result.put(entry.getKey(), entry.getValue());
//                return result;
//            }).reduce((map1, map2) -> {
//                map2.entrySet().forEach(entry -> map1.put(entry.getKey(), entry.getValue()));
//                return map1;
//            }).get();
//        } else {
//            return map.entrySet().stream().sorted((o1, o2) -> o2.getValue().compareTo(o1.getValue())).map(entry -> {
//                Map<K, V> result = new LinkedHashMap<>();
//                result.put(entry.getKey(), entry.getValue());
//                return result;
//            }).reduce((map1, map2) -> {
//                map2.entrySet().forEach(entry -> map1.put(entry.getKey(), entry.getValue()));
//                return map1;
//            }).get();
//
//        }
//
//    }
//}
