package com.cftech.showroom.appform.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.showroom.appform.model.AppForm;
import com.cftech.showroom.appform.dao.AppFormMapper;
import com.cftech.showroom.appform.model.AppFormCalendarDto;
import com.cftech.showroom.appform.model.AppFormVo;
import com.cftech.showroom.appform.model.ShowRoomRecord;
import com.cftech.showroom.appform.service.AppFormService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 展厅申请单ServiceImpl
 *
 * @author lisw
 * @date: 2019-07-31 15:40
 */
@Service("appFormService")
public class AppFormServiceImpl extends GenericServiceImpl<AppForm> implements AppFormService {

    @Autowired
    @Qualifier("appFormMapper")
    private AppFormMapper appFormMapper;

    @Override
    public GenericDao<AppForm> getGenericMapper() {
        return appFormMapper;
    }

    /**
     * 获取预约的时间是否与其他人重叠
     * @param beginTime
     * @param endTime
     * @return
     */
    @Override
    public Integer isAppointment(String beginTime, String endTime) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        return appFormMapper.isAppointment(params);
    }

    @Override
    public List<AppForm> fetchSearchByPage(Conds conds, Sort sort, int page, int pageSize, String beginTime, String endTime) {
        Map<String, Object> params = new HashMap();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        return appFormMapper.fetchSearchByPage(params);
    }

    @Override
    public List<AppFormVo> fetchSearchByPageForList(Conds conds, Sort sort, int page, int pageSize, String beginTime, String endTime) {
        Map<String, Object> params = new HashMap();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        return appFormMapper.fetchSearchByPageForList(params);
    }

    @Override
    public List<AppForm> fetchSearchByPageMobile(Conds var1, Sort var2, int var3, int var4) {
        Map<String, Object> params = new HashMap();
        params.put("conds", var1);
        params.put("offset", var3 > 0 ? var3 : 0);
        params.put("limit", var4 > 0 ? var4 : 0);
        params.put("sort", var2);
        return appFormMapper.fetchSearchByPageMobile(params);
    }

    @Override
    public List<AppFormCalendarDto> getCalendar(Conds conds) {
        Map<String,Object> params = new HashMap<>();
        params.put("conds",conds);
        return appFormMapper.getCalendar(params);
    }

    @Override
    public List<ShowRoomRecord> getRecordList(Map<String, Object> params) {
       return appFormMapper.getRecordList(params);
    }

    @Override
    public List<String> fetchGetName(Map<String, Object> params) {
        return appFormMapper.fetchGetName(params);
    }
}