package com.cftech.common.cancelitems.service.impl;

import com.cftech.common.cancelitems.model.Cancelitems;
import com.cftech.common.cancelitems.dao.CancelitemsMapper;
import com.cftech.common.cancelitems.service.CancelitemsService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 申请单详情ServiceImpl
*
* @author faye
* @date: 2019-08-19 09:45
*/
@Service("cancelitemsService")
public class CancelitemsServiceImpl extends GenericServiceImpl<Cancelitems> implements CancelitemsService {

@Autowired
@Qualifier("cancelitemsMapper")
private CancelitemsMapper cancelitemsMapper;

@Override
public GenericDao<Cancelitems> getGenericMapper() {
return cancelitemsMapper;
}

    @Override
    public List<Cancelitems> fetchCancelItems(Conds conds) {
        Map<String,Object> params = new HashMap<>();
        params.put("conds",conds);
        return cancelitemsMapper.fetchCancelItems(params);
    }
}