package com.cftech.base.org.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.base.org.model.Orgtype;
import com.cftech.base.org.service.OrgtypeService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 权限字符串说明:
 * 查看:public static final String ORGTYPE_VIEW = "sys:orgtype:view"
 * 查看:public static final String ORGTYPE_EDIT = "sys:orgtype:edit"
 * orgtypeWeb
 * Created by Neil 12/02/2017.
 */
@Slf4j
@Controller
@RequestMapping("/a/orgtype")
public class OrgtypeController {

    /**
     * orgtypeService
     */
    @Autowired
    private OrgtypeService orgtypeService;
    @Autowired
    private CodingruleUtils codingruleUtils;

    //返回列表页面
    @RequiresPermissions(value = PermissionSign.ORGTYPE_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String orgtypeList(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "managerorgtype/orgtypelist";
    }

    //返回编辑页面（新增、修改）
    @RequiresPermissions(value = PermissionSign.ORGTYPE_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {

        if (StringUtils.isNotBlank(id)) {
            Orgtype orgtype = orgtypeService.fetchById(id);
            model.addAttribute("data", orgtype);
            model.addAttribute("accountId", orgtype.getAccountsId());
        } else {
            Long accountId = UserUtils.getmpaccounts(request);
            model.addAttribute("accountId", accountId);
        }
        return "managerorgtype/orgtypeadds";
    }

    //提交编辑页面（新增、修改）
    @RequiresPermissions(value = PermissionSign.ORGTYPE_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject orgtypeListformData(Orgtype orgtype, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (orgtype != null && orgtype.getId() != null) {
                orgtype.setUpdateBy(UserUtils.getUser().getId());
                orgtypeService.update(orgtype);
                rtnJson.put("errorNo", 0);
            } else {
                orgtype.setNumber(codingruleUtils.getNumber(accountsId, Orgtype.class.getName()));
                orgtype.setDelFlag(false);
                orgtype.setAccountsId(UserUtils.getmpaccounts(request));
                orgtype.setCreateBy(UserUtils.getUser().getId());
                orgtype.setUpdateBy(UserUtils.getUser().getId());
                orgtypeService.save(orgtype);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = PermissionSign.ORGTYPE_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Orgtype orgtype, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (StringUtils.isNotBlank(orgtype.getName())) {
            conds.like("name", orgtype.getName());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);
        List<Orgtype> list = orgtypeService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer userCounts = orgtypeService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", userCounts);
        rtnJson.put("iTotalDisplayRecords", userCounts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = PermissionSign.ORGTYPE_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            orgtypeService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping(value = "/exportExcel",method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = PermissionSign.ORGTYPE_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<Orgtype> orgtypes = orgtypeService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Orgtype.class, response).toExcel(orgtypes, "组织分类信息");
    }

    @RequestMapping(value = "/templateExcel",method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = PermissionSign.ORGTYPE_EDIT)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Orgtype.class, response).toExcel(null, "组织分类信息");
    }

    @RequestMapping(value = "/importExcel",method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = PermissionSign.ORGTYPE_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return orgtypeList(request, model);
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Orgtype orgtype = new Orgtype();
                    orgtype.setAccountsId(accountId);
                    orgtype.setNumber(rowData.get(0));
                    orgtype.setName(rowData.get(1));
                    orgtypeService.save(orgtype);
                }

            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return orgtypeList(request, model);
    }
}