package com.cftech.qy.qyagent.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业应用管理
 *
 * @author Neil
 * @date: 2017-04-26 15:02
 */
@Data
public class Qyagent implements Serializable {

    /* 主键id */
    private Long id;
    /* 企业应用Id */
    @ExportConfig(value = "企业应用Id", width = 100)
    private String agentId;
    /* 企业应用名称 */
    @ExportConfig(value = "企业应用名称", width = 100)
    private String name;
    /* 应用的方形头像 */
    @ExportConfig(value = "应用的方形头像", width = 100)
    private String squareLogo;
    /* 应用的圆形头像 */
    @ExportConfig(value = "应用的圆形头像", width = 100)
    private String roundLogo;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Qyagent() {
        this.delFlag = false;
        this.status = "0";
    }

}