package com.cftech.mp.qrcode.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信带参二维码
 *
 * @author strive
 * @date: 2017-04-25 11:25
 */
@Data
public class QrCode implements Serializable {

    /* 主键id */
    private Long id;
    /* 链接码 */
    @ExportConfig(value = "链接码", width = 100)
    private String ticket;
    /* 回复类型 text，news */
    @ExportConfig(value = "回复类型 text，news", width = 100)
    private String reply_type;
    /* 回复内容 */
    @ExportConfig(value = "回复内容", width = 100)
    private String content_source;
    /* 二维码状态 */
    @ExportConfig(value = "二维码状态", width = 100)
    private String action_name;
    /* 有效时间 */
    @ExportConfig(value = "有效时间", width = 100)
    private Long expire_seconds;
    /* 短链接 */
    @ExportConfig(value = "短链接", width = 100)
    private String shortUrl;
    /* 所属的账号 */
    @ExportConfig(value = "公众号id", width = 100)
    private Long accountsId;
    /* 失效时间 */
    @ExportConfig(value = "失效时间", width = 100)
    private Date esEndtime;
    /* 二维码参数 */
    @ExportConfig(value = "二维码参数", width = 100)
    private String sence;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public QrCode() {
        this.delFlag = false;
        this.status = "0";
    }

}


