package com.cftech.core.mybatis.mybatis;

import com.cftech.core.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * Created by lisw on 2016-08-05
 */
public class EntityGenerator extends AbstractMybatisGenerator {

	/**
	 * tableBean
	 */
	private TableBean tableBean;

	/**
	 * 指定实体生成所在包的路径
	 */
	private String packageName;

	/**
	 * 是否需要导入包java.util.*
	 */
	private boolean flagUtil = false;

	/**
	 * 是否需要导入包java.sql.*
	 */
	private boolean flagSql = false;

	/**
	 * 是否需要导入包java.sql.Timestamp
	 */
	private boolean flagTimestamp = false;

	@Override
	public void outputJavaCode(TableBean tableBean) {
		if (tableBean != null) {
			this.tableBean = tableBean;
			this.flagSql = tableBean.isFlagSql();
			this.flagTimestamp = tableBean.isFlagTimestamp();
			this.flagUtil = tableBean.isFlagUtil();
			packageName = tableBean.getPackageName();

			final String tableName = tableBean.getTableName();
			final String tableComment = tableBean.getTableComment();
			final String[] columnNames = tableBean.getColumnNames();
			final String[] columnTypes = tableBean.getColumnTypes();
			final String entityString = generateEntity(tableName, tableComment, columnNames, columnTypes);

			String rootPath = "";
			if (StringUtils.isBlank(rootPath)) {
				rootPath = System.getProperty("user.dir");
			}
			if (!rootPath.endsWith("/src/main/java") || !rootPath.endsWith("src/main/java/")) {
				if (rootPath.endsWith("/")) {
					rootPath += "src/main/java/";
				} else {
					rootPath += "/src/main/java/";
				}
			}
			String modelPackage = tableBean.getPackageName();

			String filePath = rootPath + modelPackage.replace(pointStr, "/") + "/";
			String entityName = tableBean.getEntityName();
			String daoFilePath = filePath + entityName + ".java";
			outputJavaFile(daoFilePath, entityString);
		}

	}

	/**
	 * 功能：生成实体类主体代码
	 *
	 * @param tableName
	 * @param columnName
	 * @param columnType
	 * @return entity string
	 */
	private String generateEntity(String tableName, String tableComment, String[] columnName, String[] columnType) {
		StringBuffer sb = new StringBuffer();
		sb.append("package " + this.packageName + ";").append(enter);

		// 判断是否导入工具包
		if (flagUtil) {
			sb.append("import java.sql.Date;").append(enter);
		}
		if (flagSql) {
			sb.append("import java.sql.*;").append(enter);
		}
		if (flagTimestamp) {
			sb.append("import java.sql.Timestamp;").append(enter);
		}
		sb.append("import java.io.Serializable;").append(enter);
		sb.append("import lombok.Data;").append(enter);
		sb.append("import lombok.NoArgsConstructor;").append(enter);
		sb.append("import UserUtils;");
		sb.append(enter);
		// 注释部分
		sb.append("/**").append(enter);
		final String starStr = " * ";
		sb.append(starStr + tableName + " 实体类").append(enter);
		if (StringUtils.isNotBlank(tableComment)) {
			sb.append(starStr).append(tableComment).append(enter);
		}
		sb.append(" * Created by " + this.authorName + " " + DateUtils.getDate("dd/MM/yyyy") + ".").append(enter);
		sb.append(" */ ").append(enter);

		String className = tableBean.getEntityName();
		// 实体部分
		sb.append("@Data").append(enter);
		sb.append("public class ").append(className).append(" implements Serializable {").append(enter);
		processAllAttrs(sb);// 属性
		//processAllMethod(sb);// get set方法
		//生成无参构造方法
				sb.append(enter);
				sb.append("public "+className+"() {");
				sb.append(enter+tab);
				sb.append("this.delflag = false;");
				sb.append("}");
				sb.append(enter);
		sb.append("}"); 
		// System.out.println(sb.toString());
		return sb.toString(); 
	}

	/**
	 * 功能：生成所有属性
	 *
	 * @param sb
	 */
	private void processAllAttrs(StringBuffer sb) {
		String[] columnNames = tableBean.getColumnNames();
		String[] columnTypes = tableBean.getColumnTypes();
		Map<String, String> commentMap = tableBean.getCommentMap();

		for (int i = 0; i < columnNames.length; i++) {
			String columnName = columnNames[i];
			String attributeName = transLowerCamelCase(columnName);
			sb.append(tab).append("/**").append(enter);
			if (commentMap.containsKey(columnName)) {
				sb.append(tab).append(" * ").append(commentMap.get(columnName)).append(enter);
			} else {
				sb.append(tab).append(" * ").append(attributeName).append(enter);
			}
			sb.append(tab).append(" */").append(enter);
			sb.append(tab).append("private " + sqlType2JavaType(columnTypes[i]) + " " + attributeName + ";").append(enter);
			sb.append(enter);
		}

	}

	/**
	 * 功能：生成所有方法
	 *
	 * @param sb
	 */
	private void processAllMethod(StringBuffer sb) {
		String[] columnNames = tableBean.getColumnNames();
		String[] columnTypes = tableBean.getColumnTypes();
		for (int i = 0; i < columnNames.length; i++) {
			String colName = columnNames[i];
			String lowerCamelCase = transLowerCamelCase(colName);
			sb.append(tab).append("public void set" + initcap(colName) + "(" + sqlType2JavaType(columnTypes[i]) + " " + lowerCamelCase + "){").append(enter);
			sb.append(tab).append("this." + lowerCamelCase + " = " + lowerCamelCase + ";").append(enter);
			sb.append(tab).append("}").append(enter);
			sb.append(enter);
			sb.append(tab).append("public " + sqlType2JavaType(columnTypes[i]) + " get" + initcap(colName) + "(){").append(enter);
			sb.append(tab).append("\treturn " + lowerCamelCase + ";").append(enter);
			sb.append(tab).append("}").append(enter).append(enter);
		}

	}

}
