package com.cftech.order.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.order.model.*;
import com.cftech.core.generic.GenericService;

import java.io.Serializable;
import java.util.List;

/**
 * 订单管理Service
 *
 * @author Licc
 * @date: 2020-10-10 14:20
 */
public interface OrderService extends GenericService<Order> {

    /**
     * 查询订单主列表
     * @param conds
     * @param sort
     * @param page
     * @param pageSize
     * @param userid
     * @return
     */
    List<Order> fetchSearchBy(Conds conds, Sort sort, int page, int pageSize, Long userid);

    Integer count(Conds conds, Long userid);

    List<ProductOrder> listProduct();

    OrderFromVO fetchId(Serializable id);

    List<OrderFromVO> fetchProductId(Serializable id);

    Integer updateStatus(Long id, String status);

    JSONObject newlyAdded(String datas, Long accountsId);

    JSONObject deleteAll(Long id);

    /**
     * @return
     * @Author Licc
     * @Description 根据订单状态查询订单
     * @Date 15:45 2020/10/30
     * @Param
     **/
    JSONObject confirm(OrderMobileDto orderMobileDto);

    /**
     * @return
     * @Author Licc
     * @Description 订单数量
     * @Date 19:05 2020/11/3
     * @Param
     **/
    JSONObject orderSize(String openId, String appId);

    /**
     * @return
     * @Author Licc
     * @Description 根据搜索条件查询订单
     * @Date 19:05 2020/11/3
     * @Param
     **/
    JSONObject orderList(OrderMobileDto orderMobileDto);

}
