var checkForm = (function () {
    'use strict';
    var CheckForm = function (params) {
        var p = this;
        p.params = {
            appid: '',
            id: '',
            accountsId: '',
            cfApp: null,
            devMode: false,
            localStorage: [],
            getformApi: G.baseUri() + '/mobile/wxjs/getTypeAppform',
            vt: ''
        };
        for (var param in params) {
            p.params[param] = params[param];
        }

        var getQueryString = function (name) {
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
            var r = window.location.search.substr(1).match(reg);
            if (r != null) return decodeURI(r[2]);
            return null;
        };
        /**
         * 初始化组件
         * @returns {boolean}
         */


        p.init = function () {
            p.params.id=getQueryString("id");
            if (p.params.id && p.params.id != null && p.params.id != "") {
                fillData();
            }
            Handlebars.registerHelper('multiplication', function (num, price) {
                return (parseInt(num) * parseFloat(price)).toFixed(2);
            });
        };




        var fillData = function () {
            var formData = {
                id: p.params.id
            }
            $.ajax({
                type:"post",
                url:p.params.getformApi,
                data:formData,
                success:function(retdata){
                    if (retdata.errorNo == '0') {
                        if (retdata.data.status == '0' || retdata.data.status == '3') {
                            retdata.data.statusName = "待审批Waiting for approval";
                        } else if (retdata.data.issuingState == '0') {
                            retdata.data.statusName = "待发放Shipped out";
                        } else if (retdata.data.issuingState == '1') {
                            retdata.data.statusName = "已发放Delivered";
                        } else {
                            retdata.data.statusName = "";
                        }
                        retdata.data.costCenter1 = retdata.data.costCenter.split("-")[0];
                        retdata.data.costCenter2 = retdata.data.costCenter.split("-")[1];
                        var content = $('#detail-template').html();
                        p.template = Handlebars.compile(content);
                        var htmlStr = p.template(retdata);
                        $('#content').html(htmlStr);
                        //显示申请清单
                        $(".goods-list").show();
                        //显示状态
                        $("#status").val(retdata.data.statusName);
                        //状态显示
                        $("#auditStatus").show();
                        //隐藏下一步
                        $("#next_step").hide();
                        $("#bg").hide();
                        //所有input变为只读状态
                        $("input,textarea").attr("readonly", true)
                    }
                }
            })
        }




    };

    return CheckForm;
})();
