package com.cftech.workshop.statistics.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.workshop.statistics.model.*;
import com.cftech.workshop.statistics.dao.StatisticsMapper;
import com.cftech.workshop.statistics.service.StatisticsService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-07-13 13:23
 */
@Service("statisticsService")
public class StatisticsServiceImpl extends GenericServiceImpl<Statistics> implements StatisticsService {

    @Autowired
    @Qualifier("statisticsMapper")
    private StatisticsMapper statisticsMapper;

    @Override
    public GenericDao<Statistics> getGenericMapper() {
        return statisticsMapper;
    }

    //查看某个研讨会下面某个样本的总查看人数
    @Override
    public List<Sampleclick> countsampleclicks(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return statisticsMapper.countsampleclicks(params);
    };

    @Override
    public List<WorkshopType> selecttypeworkshop(Conds conds,Sort sort,int page,int pageSize){
        Map param = new HashMap();
        param.put("conds",conds);
        param.put("offset", page > 0 ? page : 0);
        param.put("limit", pageSize > 0 ? pageSize : 0);
        param.put("sort", sort);
        return statisticsMapper.selecttypeworkshop(param);
    }

    @Override
    public List<Speechclik> countspeechclicks(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return statisticsMapper.countspeechclicks(params);
    };

    @Override
    public List<Agendascore> countagendascore(Conds conds,Sort sort,int page,int pageSize){
        Map param = new HashMap();
        param.put("conds",conds);
        param.put("offset", page > 0 ? page : 0);
        param.put("limit", pageSize > 0 ? pageSize : 0);
        param.put("sort", sort);
        return statisticsMapper.countagendascore(param);
    }

}