package com.cftech.workshop.feedback.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;
import org.owasp.esapi.ESAPI;

import java.io.Serializable;
import java.util.Date;

/**
 * 意见反馈
 *
 * @author lisw
 * @date: 2019-06-18 15:23
 */
@Data
public class Feedback implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    private String number;
    /* 姓名 */
    @ExportConfig(value = "姓名", width = 100)
    private String name;
    /* 公司 */
    @ExportConfig(value = "公司", width = 100)
    private String company;
    /* 手机号码 */
    @ExportConfig(value = "手机号码", width = 100)
    private String phone;


    private String images;
    /*  */
    @ExportConfig(value = "OPENID", width = 100)
    private String field1;
    /*  */
    private String field2;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */

    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /* 邮箱 */
    @ExportConfig(value = "邮箱", width = 100)
    private String email;

    /*地址*/
    @ExportConfig(value = "所在地址", width = 100)
    private String address;

    @ExportConfig(value = "咨询时间", width = 100,dateFormat="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /* 问询类别
     *
     *  0产品购买Product inquiry=> info_China@schaeffler.com
        1质量投诉Quality complaint => parkclh@schaeffler.com
        2防伪查询Origin Check => Piracy@schaeffler.com; Piracy_CN@schaeffler.com
        3商务合作Cooperation inquiry => info_China@schaeffler.com
        4汽车售后服务Automotive Aftermarket service => xiexep@schaeffler.com
        5求职问询Job Search => CN_Recruitment@schaeffler.com
        6媒体联系News & Media => liyum@schaeffler.com
     * */

    private String type;

    public void setType(String type) {
        this.type = type;
        switch (type){
            case "0":
                this.typeName="产品购买";
                break;
            case "1":
                this.typeName="质量投诉";
                break;
            case "2":
                this.typeName="防伪查询";
                break;
            case "3":
                this.typeName="商务合作";
                break;
            case "4":
                this.typeName="求职问询";
                break;
            case "5":
                this.typeName="媒体联系";
                break;
            case "6":
                this.typeName="其他";
                break;
        }
    }


    public void setStatus(String status) {
        switch (status){
            case "0":
                this.statusName="待处理";
                break;
            case "1":
                this.statusName="已处理";
                break;
        }

        this.status = status;
    }

    @ExportConfig(value = "状态", width = 100)
    private String statusName;

    @ExportConfig(value = "咨询类型", width = 100)
    private String typeName;

    /* 反馈内容 */
    @ExportConfig(value = "咨询问题", width = 100)
    private String content;

    public Feedback() {
        this.delFlag = false;
        this.status = "0";
    }


    public void setContent(String content) {
        this.content =ESAPI.encoder().decodeForHTML(content);
    }
}