package com.cftech.workshop.agenda.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.DateUtils;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.agenda.model.*;
import com.cftech.workshop.agenda.service.AgendaService;
import com.cftech.workshop.agenda.service.AgendascoreService;
import com.cftech.workshop.agenda_customiz.model.Agenda_customizDto;
import com.cftech.workshop.agenda_customiz.service.Agenda_customizService;
import com.cftech.workshop.meeting.dao.MeetingMapper;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.service.MeetingService;
//import com.mysql.fabric.xmlrpc.base.Data;
import org.apache.poi.ss.usermodel.DateUtil;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.util.Date;
import java.util.List;

/**
 * Created by byjon 2018/7/12.
 */
@RestController
@RequestMapping(value = "/mobile/auth/agenda")
public class MobileAgendaController {

    @Autowired
    private MeetingService meetingService;

    @Autowired
    private AgendaService agendaService;

    @Autowired
    private AgendascoreService agendascoreService;

    @Autowired
    private Agenda_customizService agenda_customizService;


    /**
     * 判断是否是定制版
     * @param meetingId 研讨会ID
     * @return
     */
    @RequestMapping(value = "/selectmeetingstatus", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject selectmeetingstatus(Long meetingId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(meetingId))){
                 Meeting meeting = meetingService.fetchById(meetingId);
                if(meeting!=null){
                    if(meeting.getStatus().equals("0")){
                        jsonObject.put("errorNo",4); //标准版
                    }else{
                        jsonObject.put("errorNo",3); //定制版
                    }
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }
    /**
     * 会议议程接口
     * @param meetingId  研讨会ID
     * @type  0：标准版  1：定制版
     * @return
     */
    @RequestMapping(value = "/getagenda", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object getagenda(Long meetingId,int page , int pagesize ,String type,String member_uid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(meetingId))){
                    Meeting meeting = meetingService.fetchById(meetingId);
                    if(meeting!=null){
                        if(meeting.getStatus().equals("0")){ //标准版
                            jsonObject.put("errorNo",0);
                            jsonObject.put("workshop_title",meeting.getTitle());
                            jsonObject.put("workshop_title_en",meeting.getTitleEn());
                            Conds condsad = new Conds();
                            condsad.equal("a.workshop_id",meetingId);

                            condsad.equal("a.del_flag",0);
                            Sort sortad = new Sort("a.sort",OrderType.ASC);
                            List<AgendaDtoB> listad = agendaService.selectspeechb(condsad,sortad,page*pagesize,pagesize);
                            JSONArray jsonArray = new JSONArray();
                            if(listad!=null&&listad.size()>0){
                                for (AgendaDtoB agenda : listad){
                                    agenda.setContent_agenda(HtmlUtils.htmlUnescape(agenda.getContent_agenda()));
                                    agenda.setContent_agenda_en(HtmlUtils.htmlUnescape(agenda.getContent_agenda_en()));
                                    jsonArray.add(agenda);
                                }
                            }
                            jsonObject.put("agenda",jsonArray);  //会议信息
                            Conds conds = new Conds();
                            conds.equal("a.del_flag",0);
                            conds.equal("a.workshop_id",meetingId);

                            conds.equal("ada.member_uid",member_uid);
                            Sort sort = new Sort("a.create_time", OrderType.DESC);
                            List<AgendaDto> list =  agendaService.selectagendascore1(conds,sort,page*pagesize,pagesize);
                            JSONArray jsonArray1 = new JSONArray();
                            if(list!=null && list.size()>0){
                                for(AgendaDto agendaDto : list){
                                    agendaDto.setContent_agenda(HtmlUtils.htmlUnescape(agendaDto.getContent_agenda()));
                                    agendaDto.setContent_agenda_en(HtmlUtils.htmlUnescape(agendaDto.getContent_agenda_en()));
                                    jsonArray1.add(agendaDto);
                                    //jsonObject.put("data",agendaDto);
                                }

                            }
                            jsonObject.put("data",jsonArray1); //用户打分信息
                        }else{  //定制版
                            jsonObject.put("errorNo",3);
                            jsonObject.put("workshop_title",meeting.getTitle());
                            jsonObject.put("workshop_title_en",meeting.getTitleEn());
                            Conds conds = new Conds();
                            conds.equal("workshop_id",meetingId);
                            conds.equal("del_flag",0);
                            Sort sort = new Sort("create_time",OrderType.ASC);
                            List<Agenda> list = agendaService.selectagendacustomiz(conds,sort,0,0);
                            JSONArray jsonArray = new JSONArray();
                            JSONObject jsonObject1 = null;
                            if(list != null && list.size()>0){  //获得会议时间
                                for (Agenda agenda : list){
                                    jsonObject1 = new JSONObject();
                                    jsonObject1.put("agenda_time",agenda.getAgenda_time());
                                    jsonArray.add(jsonObject1);
                                }
                                jsonObject.put("data",jsonArray);
                            }

                        }

                     }


            }else{
                jsonObject.put("errorNo",2);
            }

        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }

        return  jsonObject;
    }

    /**
     * 定制版选择会议时间
     * @param meetingId  研讨会ID
     * @param page
     * @param pagesize
     * @param agenda_time
     * @return
     */
    @RequestMapping(value = "/selectagendacustomiz", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
        public JSONObject selectagendacustomiz(Long meetingId,int page , int pagesize,String agenda_time){
        JSONObject jsonObject = new JSONObject();
        try {
            if(meetingId!=0&&StringUtils.isNoneBlank(agenda_time)){
                Conds conds = new Conds();
                conds.equal("a.agenda_time",DateUtils.parseDate(agenda_time));
                conds.equal("a.del_flag",0);
                conds.notEqual("ac.customiz_name","null");
                Sort sort = new Sort("ac.sort",OrderType.ASC );
                List<Agenda_customizDto> list = agenda_customizService.selectcustomizname(conds,sort,page,pagesize);
                JSONObject jsonObject1 = null;
                JSONArray jsonArray = new JSONArray();
                if(list!=null&&list.size()>0){
                    jsonObject.put("errorNo",0);
                    for(Agenda_customizDto agenda_customizDto : list){
                        jsonObject1 = new JSONObject();
                        jsonObject1.put("agenda_customiz",agenda_customizDto.getCustomiz_name());
                        jsonObject1.put("agenda_customiz_nameEn",agenda_customizDto.getCustomiz_name_en());
                        jsonObject1.put("agenda_id",agenda_customizDto.getId());
                        jsonObject1.put("ids",agenda_customizDto.getIds());
                        jsonArray.add(jsonObject1);
                    }

                    jsonObject.put("data",jsonArray);
                }

            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 定制版点击会场接口
     * @param agenda_id 会场id
     * @return
     */
    @RequestMapping(value = "/clickcustomizagenda", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject clickcustomizagenda(Long agenda_id,String meetingId,String member_uid,String agenda_time,Long ids){
        JSONObject jsonObject = new JSONObject();
        try {
            if(agenda_id!=0&&StringUtils.isNoneBlank(meetingId)&&StringUtils.isNoneBlank(member_uid)){
                Conds conds = new Conds();
                conds.equal("ac.id",agenda_id);
                conds.equal("a.del_flag",0);
                if(StringUtils.isNoneBlank(agenda_time)){
                    conds.equal("a.agenda_time",agenda_time);
                }
                Sort sort1 = new Sort("a.sort",OrderType.ASC);
                List<AgendaSpeech> agendaSpeech = agendaService.selectagendaspeech(conds,sort1);
                JSONArray jsonArray = new JSONArray();
                if(agendaSpeech!=null&&agendaSpeech.size()>0){
                    jsonObject.put("errorNo",0);
                    for(AgendaSpeech agendaSpeech1 : agendaSpeech){
                        agendaSpeech1.setContent_agenda(ESAPI.encoder().decodeForHTML(agendaSpeech1.getContent_agenda()));
                        agendaSpeech1.setContent_agenda_en(ESAPI.encoder().decodeForHTML(agendaSpeech1.getContent_agenda_en()));
                        jsonArray.add(agendaSpeech1);
                    }
                    jsonObject.put("data",jsonArray);
                }
                Conds conds1 = new Conds();
                conds1.equal("a.del_flag",0);
                conds1.equal("a.workshop_id",meetingId);
                conds1.equal("ada.member_uid",member_uid);
                Sort sort = new Sort("a.sort", OrderType.ASC);
                List<AgendaDto> list =  agendaService.selectagendascore1(conds1,sort,0,0);
                JSONArray jsonArray1 = new JSONArray();
                if(list!=null && list.size()>0){
                    for(AgendaDto agendaDto : list){
                        agendaDto.setContent_agenda(HtmlUtils.htmlUnescape(agendaDto.getContent_agenda()));
                        agendaDto.setContent_agenda_en(HtmlUtils.htmlUnescape(agendaDto.getContent_agenda_en()));
                        jsonArray1.add(agendaDto);
                    }

                }
                jsonObject.put("score1",jsonArray1); //用户打分信息
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }



    /**
     * 提交会议议程评分
     * @param agendascore
     * @return
     */
    @RequestMapping(value = "/inseragendasroe", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject inseragendasroe(String agendascore){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(agendascore)){
                    agendascoreService.addagendascore(agendascore);
                    jsonObject.put("errorNo",0);
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }
}
