package com.cftech.showroom.appform.util;

import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.License;
import com.aspose.words.SaveFormat;
import com.cftech.core.util.SystemConfig;

import java.io.*;
import java.util.Map;
import java.util.UUID;

/**
 * @Auther: lisw
 * @Date: 2019/8/5 13:34
 * @Description:
 */
public class DocToPdf {

    static String docTemplatePath = SystemConfig.p.getProperty("docXmlTemplatePath");
static String licensePath=SystemConfig.p.getProperty("licensePath");
    static String outPath=System.getProperty("java.io.tmpdir")+"/";

//    static String docTemplatePath = "E:/文档/信睿/舍弗勒/2020/品牌申请/开发文档/";
//    static String licensePath= "license.xml";
//    static String outPath="E:\\文档\\信睿\\舍弗勒\\2020\\品牌申请\\schaeffler(3)\\";
    public static boolean getLicense() {
        boolean result = false;
        try {
            InputStream is = new FileInputStream(docTemplatePath+licensePath); // license.xml应放在..\WebRoot\WEB-INF\classes路径下
            License aposeLic = new License();
            aposeLic.setLicense(is);
            result = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static  String DocToPdf(Map<String,Object> params,String documentXmlName,String documentDocName) throws Exception {
        try{
            if (!getLicense()) { // 验证License 若不验证则转化出的pdf文档会有水印产生
                return null;
            }
            String templateUUId = UUID.randomUUID().toString();
            String xml = outPath+templateUUId+".xml";
            XmlToDocx.toDocx(documentXmlName,docTemplatePath+documentDocName,xml,outPath+templateUUId+".docx",params);
            long old = System.currentTimeMillis();
            String docx = outPath+templateUUId+".docx";
            String pdf = outPath+templateUUId+".pdf";
            File file = new File(pdf); // 新建一个空白pdf文档
            FileOutputStream os = new FileOutputStream(file);
            Document doc = new Document(docx); // Address是将要被转化的word文档
            String osName = isWindows();
            String fonts [] = null;
            /**
             * 适配字体文件
             */
            if(osName.equals("linux")){
                fonts = new String[]{"/usr/share/fonts/chinese/","/usr/share/fonts/simsun/","/usr/share/fonts/black/","/usr/share/fonts/wingdings/"};
                FontSettings.setFontsFolders(fonts, true);
            }else if(osName.equals("mac")){
                fonts = new String[]{"/Users/fonts/chinese/","/Users/fonts/simsun/","/Users/fonts/black/","/Users/fonts/wingdings/"};
                FontSettings.setFontsFolders(fonts, true);
            }
            doc.save(os, SaveFormat.PDF);// 全面支持DOC, DOCX, OOXML, RTF HTML, OpenDocument, PDF,
            if(os!=null){
                os.close();
            }
            delete(xml,docx);//删除文件
            return pdf;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }
    private static String isWindows() {
        String osName = System.getProperties().getProperty("os.name").toUpperCase();
        if(osName.indexOf("WINDOWS")!=-1){
            return "windows";
        }else if(osName.indexOf("MAC")!=-1){
            return "mac";
        }else{
            return "linux";
        }
    }
    public static void delete(String xmlPath,String wordPath){
        File file = new File(xmlPath);
        if(file.exists()){
            file.delete();
        }
        File wordFile = new File(wordPath);
        if(wordFile.exists()){
            wordFile.delete();
        }
    }

}
