package com.cftech.base.appmenu.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.appmenu.model.Appmenu;
import com.cftech.base.appmenu.service.AppmenuService;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * 权限字符串说明:
 * 查看:public static final String APPMENU_VIEW = "qy:appmenu:view"
 * 查看:public static final String APPMENU_EDIT = "qy:appmenu:edit"
 * appmenuWeb
 * Created by Neil 28/02/2017.
 */
@Slf4j
@Controller
@RequestMapping("/a/appmenu")
public class AppmenuController {

    /**
     * appmenuService
     */
    @Autowired
    private AppmenuService appmenuService;
    @Autowired
    private CodingruleUtils codingruleUtils;

    //返回列表页面
    @RequiresPermissions(value = PermissionSign.APPMENU_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String appmenuList(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "managerappmenu/appmenulist";
    }

    //返回编辑页面（新增、修改）
    @RequiresPermissions(value = PermissionSign.APPMENU_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {

        if (StringUtils.isNotBlank(id)) {
            Appmenu appmenu = appmenuService.fetchById(id);
            model.addAttribute("data", appmenu);
            model.addAttribute("accountId", appmenu.getAccountsId());
        } else {
            Long accountId = UserUtils.getmpaccounts(request);
            model.addAttribute("accountId", accountId);
        }
        return "managerappmenu/appmenuadds";
    }

    //提交编辑页面（新增、修改）
    @RequiresPermissions(value = PermissionSign.APPMENU_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject appmenuListformData(Appmenu appmenu, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (appmenu != null && appmenu.getId() != null) {
                appmenu.setUpdateBy(UserUtils.getUser().getId());
                appmenuService.update(appmenu);
                rtnJson.put("errorNo", 0);
            } else {
                appmenu.setNumber(codingruleUtils.getNumber(accountsId, Appmenu.class.getName()));
                appmenu.setDelFlag(false);
                appmenu.setAccountsId(UserUtils.getmpaccounts(request));
                appmenu.setCreateBy(UserUtils.getUser().getId());
                appmenu.setUpdateBy(UserUtils.getUser().getId());
                appmenuService.save(appmenu);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = PermissionSign.APPMENU_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Appmenu appmenu, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (StringUtils.isNotBlank(appmenu.getName())) {
            conds.like("name", appmenu.getName());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);
        List<Appmenu> list = appmenuService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer userCounts = appmenuService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", userCounts);
        rtnJson.put("iTotalDisplayRecords", userCounts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = PermissionSign.APPMENU_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            appmenuService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping(value = "/exportExcel",method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = PermissionSign.APPMENU_EDIT)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<Appmenu> appmenus = appmenuService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Appmenu.class, response).toExcel(appmenus, "组织分类信息");
    }

    @RequestMapping(value = "/templateExcel",method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = PermissionSign.APPMENU_EDIT)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Appmenu.class, response).toExcel(null, "组织分类信息");
    }

    @RequestMapping(value = "/importExcel",method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = PermissionSign.APPMENU_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return appmenuList(request, model);
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Appmenu appmenu = new Appmenu();
                    appmenu.setAccountsId(accountId);
                    appmenu.setNumber(rowData.get(0));
                    appmenu.setName(rowData.get(1));
                    appmenuService.save(appmenu);
                }

            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return appmenuList(request, model);
    }
}