package com.cftech.pay.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付记录
 *
 * @author Kangliang
 * @date: 2017-05-16 13:04
 */
@Data
public class PayRecord implements Serializable {

    /* 主键id */
    private Long id;
    /* 来源系统ID */
    @ExportConfig(value = "来源系统ID", width = 100, showLevel = 1)
    private String srcid;
    /* 来源系统类型 */
    @ExportConfig(value = "来源系统类型", width = 100, showLevel = 1)
    private String srctype;
    /* 商户号 */
    @ExportConfig(value = "商户号", width = 100, showLevel = 1)
    private String mch_id;
    /* 错误码 */
    @ExportConfig(value = "错误码", width = 100, showLevel = 1)
    private String err_code;
    /* 错误描述 */
    @ExportConfig(value = "错误描述", width = 100, showLevel = 1)
    private String err_code_des;
    /* openid */
    @ExportConfig(value = "openid", width = 100, showLevel = 1)
    private String openid;
    /* 交易类型 */
    @ExportConfig(value = "交易类型", width = 100, showLevel = 1)
    private String trade_type;
    /* 是否关注 */
    @ExportConfig(value = "是否关注", width = 100, showLevel = 1)
    private String is_subscribe;
    /* 付款银行 */
    @ExportConfig(value = "付款银行", width = 100, showLevel = 1)
    private String bank_type;
    /* 总金额 */
    @ExportConfig(value = "总金额", width = 100, showLevel = 1)
    private String total_fee;
    /* 货币种类 */
    @ExportConfig(value = "货币种类", width = 100, showLevel = 1)
    private String fee_type;
    /* 现金支付金额 */
    @ExportConfig(value = "现金支付金额", width = 100, showLevel = 1)
    private String cash_fee;
    /* 现金支付货币类型 */
    @ExportConfig(value = "现金支付货币类型", width = 100, showLevel = 1)
    private String cash_fee_type;
    /* 微信支付订单号 */
    @ExportConfig(value = "微信支付订单号", width = 100, showLevel = 1)
    private String transaction_id;
    /* 商户订单号 */
    @ExportConfig(value = "商户订单号", width = 100, showLevel = 1)
    private String out_trade_no;
    /* 商家数据包 */
    @ExportConfig(value = "商家数据包", width = 100, showLevel = 1)
    private String attach;
    /* 支付完成时间 */
    @ExportConfig(value = "支付完成时间", width = 100, showLevel = 1)
    private Date time_end;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public PayRecord() {
        this.delFlag = false;
        this.status = "0";
    }

}