package com.cftech.mp.fans.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.util.MpTokenUtil;
import com.cftech.mp.fans.dao.FanssgroupMapper;
import com.cftech.mp.fans.model.Fanssgroup;
import com.cftech.mp.fans.service.FanssgroupService;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.core.req.model.user.Tag;
import org.mp.api.core.req.model.user.TagOperate;
import org.mp.api.wxuser.tag.JwTagAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * fanssgroupService
 * Created by mubo 30/12/2016.
 */
@Service("fanssgroupService")
public class FanssgroupServiceImpl extends GenericServiceImpl<Fanssgroup> implements FanssgroupService {

	/**
	 * fanssgroupMapper
	 */
	@Autowired
	@Qualifier("fanssgroupMapper")
	private FanssgroupMapper fanssgroupMapper;

	@Autowired
	private MpTokenUtil tokenUtil;
	

	@Override
	public GenericDao<Fanssgroup> getGenericMapper() {
		return fanssgroupMapper;
	}

	@Override
	public Boolean deletelabel(Fanssgroup fanssgroup,Long accountsid) {
		TagOperate to = JwTagAPI.removeTag(Integer.valueOf(fanssgroup.getGroupid().toString()), tokenUtil.getToken(accountsid));
		Boolean res = false;
		if(to.getErrcode()==0){
			int result=getGenericMapper().delete(fanssgroup.getId());
			if(result>0){
				res=true;
			}
		}else{
			res = false; 
		}
		return res;
	}

	@Override
	public Boolean savelabel(Fanssgroup fanssgroup, Long accountsid) throws WexinReqException {
		Boolean result = false;
		Tag tag = new Tag();
		tag.setName(fanssgroup.getName());
		TagOperate to=JwTagAPI.createTag(tag, tokenUtil.getToken(accountsid));
		if(to.getErrcode()==null){
			Long groupid = Long.valueOf(to.getTag().getId().toString());
			fanssgroup.setGroupid(groupid);
			Long deleteresult=getGenericMapper().save(fanssgroup);
			if(deleteresult>0){
				result=true;
			}
		}else{
			result = false; 
		}
		return result;
	}

	/* (non-Javadoc)
	 * @see com.cftech.mp.fans.service.FanssgroupService#updatelabel(com.cftech.mp.fans.model.Fanssgroup, java.lang.Long)
	 */
	@Override
	public Boolean updatelabel(Fanssgroup fanssgroup, Long accountsid) {
		Boolean result = false;
		Tag tag = new Tag();
		tag.setId(Integer.valueOf(fanssgroup.getGroupid().toString()));
		tag.setName(fanssgroup.getName());
		TagOperate to=JwTagAPI.editTag(tag, tokenUtil.getToken(accountsid));
		if(to.getErrcode()==0){
			int deleteresult=getGenericMapper().update(fanssgroup);
			if(deleteresult>0){
				result=true;
			}
		}else{
			result = false; 
		}
		return result;
	}
}
