package com.cftech.cms.exhibi_sample.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.exhibi_sample.model.Exhibi_sample;
import com.cftech.cms.exhibi_sample.service.Exhibi_sampleService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 展会展品信息接口
 * Created by Ago on 2018/9/11.
 */
@RestController
@RequestMapping(value = "/mobile/auth/exhibi_sample")
public class MobileExhibisampleController {

    @Autowired
    private Exhibi_sampleService exhibi_sampleService;

    @RequestMapping(value = "/getexhibi_sample",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getexhibi_sample(Long exhibi_id,int page,int pagesize,String type,String sample_title,Long accountsId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(exhibi_id))){
                Conds conds = new Conds();
                conds.equal("exhibi_id",exhibi_id);
                conds.equal("del_flag",0);
                if(type.equals("")){ //中文
                    if(StringUtils.isNoneBlank(sample_title)){
                        conds.like("sample_title",sample_title);
                    }
                }else{  //英文
                    if(StringUtils.isNoneBlank(sample_title)){
                        conds.like("sample_title_en",sample_title);
                    }
                }
                Sort sort = new Sort("sort", OrderType.ASC);
                List<Exhibi_sample> list = exhibi_sampleService.fetchSearchByPage(conds,sort,page*pagesize,pagesize);
                if(list!=null && list.size()>0){
                    jsonObject.put("errorNo",0);
                    jsonObject.put("data",list);
                }
            }else{
                jsonObject.put("errorNo",2); //参数报错
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    @RequestMapping(value = "/getsampledetail",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getsampledetail(Long id){
        JSONObject jsonObject = new JSONObject();
        try{
            if(StringUtils.isNoneBlank(String.valueOf(id))){
                Exhibi_sample exhibi_sample = exhibi_sampleService.fetchById(id);
                if(exhibi_sample != null){
                    jsonObject.put("errorNo",0);
                    exhibi_sample.setContent_sample(ESAPI.encoder().decodeForHTML(exhibi_sample.getContent_sample()));
                    exhibi_sample.setContent_sample_en(ESAPI.encoder().decodeForHTML(exhibi_sample.getContent_sample_en()));
                    jsonObject.put("data",exhibi_sample);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

}
