package com.cftech.cms.exhibi_material.web;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.exhibi_inquiries.service.Exhibi_inquiriesService;
import com.cftech.cms.exhibi_material.model.Exhibi_material;
import com.cftech.cms.exhibi_material.service.Exhibi_materialService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/mobile/auth/material")
public class MobileExhibi_materialController {

    @Autowired
    private Exhibi_materialService exhibi_materialService;

    /**
     * 查询某展会下面的样本资料信息
     * @param exhibi_id 展会ID
     * @return
     */
    @RequestMapping(value = "/selectMaterial" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject selectMaterial(@RequestParam String exhibi_id){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("exhibi_id",exhibi_id);
            conds.equal("del_flag",0);
            Sort sort = new Sort("size",OrderType.ASC);
            List<Exhibi_material> list = exhibi_materialService.fetchSearchByPage(conds,sort,0,0);
            if(list!=null&&list.size()>0){
                Double sum = 0.0;
                for(Exhibi_material exhibi_material : list){
                    sum = sum+exhibi_material.getSize();
                }
                jsonObject.put("data",list);
                jsonObject.put("count",list.size());
                jsonObject.put("size",sum);
                jsonObject.put("errorNo",0);
            }else{
                jsonObject.put("errorNo",1);
            }

        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 样本资料详情
     * @param id 资料ID
     * @return
     */
    @RequestMapping(value = "/MaterialDetail" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject MaterialDetail(@RequestParam String id){
        JSONObject jsonObject = new JSONObject();
        try {
            Exhibi_material exhibi_material = exhibi_materialService.fetchById(id);
            if(exhibi_material!=null){
                jsonObject.put("errorNo",0);
                jsonObject.put("data",exhibi_material);
            }else{
                jsonObject.put("errorNo",1);
            }
        }catch(Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }
}
