package com.cftech.core.config;
import com.cftech.core.util.SystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Created by liuling on 16/4/22.
 */
public class MpGlobalConfig {

    private static Logger logger = LoggerFactory.getLogger(MpGlobalConfig.class);

    public  static final boolean TOKEN_REFRESH =  Boolean.valueOf(SystemConfig.p.getProperty("list.refreshtoken"));

    public static final String JWT_DOMAIN = SystemConfig.p.getProperty("jwt.domain");
    public static final int  JWT_DURATION = Integer.valueOf(SystemConfig.p.getProperty("jwt.duration"));
    public static final boolean SECURITY_SECURE = Boolean.valueOf(SystemConfig.p.getProperty("security.secure"));
    //是否使用七牛云,或者腾讯云
    public enum CloudFiles {
        qiniu, qcloud
    }

    // 水印位置（无、左上、右上、居中、左下、右下）
    public enum WatermarkPosition {
        no, topLeft, topRight, center, bottomLeft, bottomRight
    }

    // 刘总 七牛云的配置
//    public static final String QN_ACCESS_KEY = "2vag2flCONbJ02Kjm77mdYc2t1ToPogSRXMNsaiD";
//    public static final String QN_SECRET_KEY= "Lk7IohOB7A1wT-YL_RWlMwxeQodSHTvY1D4f9TpS";
//    public static final String QN_BACKET_NAME = "neil";
    
    public static final String QN_ACCESS_KEY = SystemConfig.p.getProperty("QN_ACCESS_KEY");
//    
    public static final String QN_SECRET_KEY = SystemConfig.p.getProperty("QN_SECRET_KEY");
//    
    public static final String QN_BACKET_NAME = SystemConfig.p.getProperty("QN_BACKET_NAME");
    
    
    

    // 默认商品图片（大）文件名称(不包含扩展名)
    public static final String BIG_IMAGE_FILE_NAME = "big";
    // 默认商品图片（小）文件名称(不包含扩展名)
    public static final String SMALL_IMAGE_FILE_NAME = "small";
    // 商品缩略图文件名称(不包含扩展名)
    public static final String THUMBNAIL_IMAGE_FILE_NAME = "thumbnail";
    // 水印图片文件名称(不包含扩展名)
    public static final String WATERMARK_IMAGE_FILE_NAME = "watermark";
    // 图片文件上传目录
    public static final String UPLOAD_IMAGE_DIR = "/Users/liuling/tools/apache-tomcat-8.0.15/data/mp/image/";
    // 媒体文件上传目录
    public static final String UPLOAD_MEDIA_DIR = "/Users/liuling/tools/apache-tomcat-8.0.15/data/mp/media/";
    // 其它文件上传目录
    public static final String UPLOAD_FILE_DIR = "/Users/liuling/tools/apache-tomcat-8.0.15/data/mp/file/";
    // 缓存目录
    public static final String TEMP_PATH = "/Users/liuling/tools/apache-tomcat-8.0.15/data/mp/temp";
    
    public static final Integer IMAGE_UPLOAD_MAXSIZE = 1024*1000*200;
    
    // 文件上传最大值,0表示无限制,单位KB,默认20M,总量控制
    public static final Integer UPLOAD_MAXSIZE  = 1024*1000*200;

    public static final String UPLOAD_TO = "qiniu";

    public static RequestMethod getMethod()
    {
        if(TOKEN_REFRESH)
        {
            return RequestMethod.POST;
        }else
        {
            return RequestMethod.GET;
        }
    }

}
