package com.cftech.productclassify.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.productclassify.service.ProductclassifyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @author ：licc
 * @date ：Created in 2020/10/21 17:46
 * @description：
 */
@Slf4j
@RestController
@RequestMapping("/mobile/auth/productclassify")
public class MobileclassifyController {
    @Autowired
    private com.cftech.productclassify.service.ProductclassifyService ProductclassifyService;
    /**
     * @Author Licc
     * @Description  商品列表展示
     * @Date 14:14 2020/10/21
     * @Param
     * @return
     **/
    @RequestMapping(value = "/productList",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject productList(@RequestParam(required = false) String productName, @RequestParam(required = false)String classifyName,@RequestParam(required = false) String dosagaFrom,@RequestParam(required = true)String appId){
        return ProductclassifyService.productList(productName,classifyName,dosagaFrom,appId);
    }
    /**
     * @Author Licc
     * @Description  商品分类菜单数据回填
     * @Date 9:46 2020/10/22
     * @Param []
     * @return com.alibaba.fastjson.JSONObject
     **/
    @RequestMapping(value = "/productMenu",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject productMenu(String appId){
        return ProductclassifyService.productMenu(appId);
    }
    /**
     * @Author Licc
     * @Description  商品分类菜单剂型回填
     * @Date 9:46 2020/10/22
     * @Param []
     * @return com.alibaba.fastjson.JSONObject
     **/
    @RequestMapping(value = "/productDosage",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject productDosage(@RequestParam String appId,
                                    @RequestParam(required = false) String dosageName){
        return ProductclassifyService.productDosage(appId,dosageName);
    }
    /**
     * @Author Licc
     * @Description 热门推荐
     * @Date 19:40 2020/11/2
     * @Param  
     * @return 
     **/
    @RequestMapping(value = "/hotproduct",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject hotproduct(String appId){
        return ProductclassifyService.hotproduct(appId);
    }
    /**
     * @Author Licc
     * @Description 好药推荐
     * @Date 19:40 2020/11/2
     * @Param
     * @return
     **/
    @RequestMapping(value = "/medicine",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject medicine(String appId){
        return ProductclassifyService.medicine(appId);
    }

}
