package com.cftech.productclassify.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.productclassify.model.ProductMenuVO;
import com.cftech.productclassify.model.ProductVO;
import com.cftech.productclassify.model.Productclassify;
import com.cftech.productclassify.dao.ProductclassifyMapper;
import com.cftech.productclassify.model.ProductclassifyVO;
import com.cftech.productclassify.service.ProductclassifyService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.esotericsoftware.minlog.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 产品分类ServiceImpl
 *
 * @author Buyj
 * @date: 2020-09-22 18:06
 */
@Service("productclassifyService")
public class ProductclassifyServiceImpl extends GenericServiceImpl<Productclassify> implements ProductclassifyService {

    @Autowired
    @Qualifier("productclassifyMapper")
    private ProductclassifyMapper productclassifyMapper;
    @Autowired
    private MpAccountsService mpAccountsService;
    @Override
    public GenericDao<Productclassify> getGenericMapper() {
        return productclassifyMapper;
    }

    @Override
    public List<Productclassify> fetchTreeByPage(Conds conds, Sort sort, int pageNo, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("offset", pageNo > 0 ? pageNo : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return productclassifyMapper.fetchTreeByPage(params);
    }

    @Override
    public JSONObject productList(String productName,  String classifyName, String dosagaFrom,String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            if (StringUtils.isBlank(productName)) {
                productName = null;
            }
            if (StringUtils.isBlank(classifyName)) {
                classifyName = null;
            }
            if (StringUtils.isBlank(dosagaFrom)) {
                dosagaFrom = null;
            }
            List<ProductclassifyVO> productVOS = productclassifyMapper.productList(productName, classifyName, dosagaFrom);
            if (productVOS==null){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorNo","查询失败");
                return rtnJson;
            }
            Log.info("返回结果:"+productVOS);
            rtnJson.put("errorNo","0");
            rtnJson.put("data",productVOS);

        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo","1");
        }


        return rtnJson;

    }

    @Override
    public JSONObject productMenu(String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<ProductMenuVO> menu = productclassifyMapper.productMenu();
            if (menu==null){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","查询失败");
                return rtnJson;
            }
            Log.info("返回结果:"+menu);
            rtnJson.put("errorNo","0");
            rtnJson.put("data",menu);

        }catch (Exception e){
           e.printStackTrace();
            rtnJson.put("errorNo","1");
        }
        return rtnJson;
    }

    @Override
    public JSONObject hotproduct(String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<ProductVO> hotproduct = productclassifyMapper.hotproduct();
            if (hotproduct==null){
                rtnJson.put("errorNO","1");
                rtnJson.put("errorMsg","查询失败");
                return rtnJson;
            }
            Log.info("返回结果:"+hotproduct);
            rtnJson.put("errorNo","0");
            rtnJson.put("data",hotproduct);
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNO","1");
        }

        return rtnJson;
    }

    @Override
    public JSONObject medicine(String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<ProductVO> medicine = productclassifyMapper.medicine();
            if (medicine==null){
                rtnJson.put("errorNO","1");
                rtnJson.put("errorMsg","查询失败");
                return rtnJson;
            }
            Log.info("返回结果:"+medicine);
            rtnJson.put("errorNo","0");
            rtnJson.put("data",medicine);
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNO","1");
        }

        return rtnJson;
    }

    @Override
    public String selectIdsByNumber(String classifyNumber) {
        return productclassifyMapper.selectIdsByNumber(classifyNumber);
    }

    @Override
    public JSONObject productDosage(String appId, String dosageName) {
        JSONObject rtnJson = new JSONObject();

        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<ProductVO> productVOS = productclassifyMapper.productDosage();
            if (productVOS==null){
                rtnJson.put("errorNO","1");
                rtnJson.put("errorMsg","查询失败");
                return rtnJson;
            }
            Log.info("返回结果:"+productVOS);
            rtnJson.put("errorNo","0");
            rtnJson.put("data",productVOS);
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNO","1");
        }

        return rtnJson;
    }

}