package com.cftech.workshop.template.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;
import org.owasp.esapi.ESAPI;

import java.io.Serializable;
import java.util.Date;

/**
 * 研讨会模板消息
 *
 * @author lisw
 * @date: 2018-07-18 16:45
 */
@Data
public class Template implements Serializable {

    /* 主键id */
    private Long id;
    /* 模板类型 */
    @ExportConfig(value = "模板类型", width = 100)
    private String type;
    /* 模板推送时间 */
    @ExportConfig(value = "模板推送时间", width = 100)
    private Date sendTime;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private String uuid;

    private String name;

    private String sendTimeStr;

    private String content;

    private String jobname;

    private String sendMessage;

    private String meetingId;
    private String templateId;

    private String url;





    public Template() {
        this.delFlag = false;
        this.status = "0";
    }

}