package com.cftech.base.org.service.impl;

import com.cftech.base.org.dao.OrgUnitMapper;
import com.cftech.base.org.model.OrgUnit;
import com.cftech.base.org.model.vo.OrgUnitVO;
import com.cftech.base.org.service.OrgUnitService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * brandnewsService
 * Created by mb 07/11/2016.
 */
@Service("orgUnitService")
public class OrgUnitServiceImpl extends GenericServiceImpl<OrgUnit> implements OrgUnitService {

	@Autowired
	private OrgUnitMapper orgUnitMapper;

	@Override
	public GenericDao<OrgUnit> getGenericMapper() {
		return orgUnitMapper;
	}


	@Override
	public List<OrgUnit> findAllChildren(Long orgId) {
		return orgUnitMapper.findAllChildren(orgId);
	}

	@Override
	@Cacheable(value = "orgunitCache", key = "#accountId.toString()")
	public List<OrgUnit> findAllByAccountId(Long accountId) {
		return orgUnitMapper.findAllByAccountId(accountId);
	}

	@Override
	@CacheEvict(value = "orgunitCache", key = "#orgUnit.accountsId.toString()")
	public boolean saveCache(OrgUnit orgUnit) {
		return this.save(orgUnit);
	}

	@Override
	@CacheEvict(value = "orgunitCache", key = "#orgUnit.accountsId.toString()")
	public boolean updateCache(OrgUnit orgUnit) {
		return this.update(orgUnit);
	}

	@Override
	public boolean move(Map<String, Object> map) {
		return orgUnitMapper.move(map);
	}

	@Override
	public List<OrgUnitVO> fetchSearchVOByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize) {
		Map<String, Object> params = new HashMap<>();
		if (orgId == 0) {
			params.put("orgId", orgId);
		} else {
			params.put("orgId", "," + orgId);
		}

		params.put("conds", conds);
		params.put("offset", page > 0 ? page : 0);
		params.put("limit", pageSize > 0 ? pageSize : 0);
		params.put("sort", sort);
		return orgUnitMapper.fetchSearchVOByPage(params);
	}

	@Override
	public List<OrgUnit> fetchSearchByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize) {
		Map<String, Object> params = new HashMap<>();

//		if (orgId == 0) {
//			params.put("orgId", orgId);
//		} else {
//			params.put("orgId", "," + orgId);
//		}

		params.put("conds", conds);
		params.put("offset", page > 0 ? page : 0);
		params.put("limit", pageSize > 0 ? pageSize : 0);
		params.put("sort", sort);
		return orgUnitMapper.fetchSearchByPage(params);
	}

	@Override
	public int count(Long orgId, Conds conds) {
		Map<String, Object> params = new HashMap<>();
		if (orgId == 0) {
			params.put("orgId", orgId);
		} else {
			params.put("orgId", "," + orgId);
		}
		params.put("conds", conds);
		return orgUnitMapper.count(params);
	}

	@Override
	public void changeStatus(String status, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("status", status);
        orgUnitMapper.changeStatus(params);
    }

	@Override
	public OrgUnit findByAccountIdAndNumber(Long accountId, String number) {
		Conds myCond = new Conds();
		myCond.equal("t.del_flag", Constants.DEL_FLAG_0);
		myCond.equal("t.accounts_id", accountId);
		myCond.equal("t.number", number);
		return fetchSearchByConds(myCond);
	}


}
