package com.cftech.cms.special.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * CMS专题管理
 *
 * @author lisw
 * @date: 2017-05-03 10:21
 */
@Data
public class Special implements Serializable {

    /* 主键id */
    private Long id;
    /*  */
    @ExportConfig(value = "", width = 100)
    private String name;
    /* 专题图片 */
    @ExportConfig(value = "专题图片", width = 100)
    private String img;
    /* 专题描述 */
    @ExportConfig(value = "专题描述", width = 100)
    private String remarks;
    /* 专题排序 */
    @ExportConfig(value = "专题排序", width = 100)
    private Integer sort;
    /* 是否显示 0:显示  1:不显示 */
    @ExportConfig(value = "是否显示 0:显示  1:不显示", width = 100)
    private Integer ishow;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Special() {
        this.delFlag = false;
        this.status = "0";
    }
}