package com.cftech.cms.exhibi_vocation.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.exhibi_vocation.model.Exhibi_vocation;
import com.cftech.cms.exhibi_vocation.service.Exhibi_vocationService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by Ago on 2018/9/14.
 */
@RestController
@RequestMapping(value = "/mobile/auth/exhibivacation")
public class MobileExhibi_vocationController {
    @Autowired
    private Exhibi_vocationService exhibi_vocationService;

    /**
     * 判断是否填过身份类型
     * @param openId 微信OPENID
     * @param exhibi_id 展会id
     * @return
     */
    @RequestMapping(value = "/isvocation" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject isvocation(String openId,Long exhibi_id){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(openId)&&StringUtils.isNoneBlank(String.valueOf(exhibi_id))){
                Conds conds = new Conds();
                conds.equal("open_id",openId);
                conds.equal("exhibi_id",exhibi_id);
                conds.equal("del_flag",0);
                Exhibi_vocation exhibi_vocation = exhibi_vocationService.selectByConds(conds);
                if(exhibi_vocation!=null){
                    if(StringUtils.isNoneBlank(exhibi_vocation.getVocation())){
                        //填写过人员信息
                        jsonObject.put("errorNo",0);
                    }else{
                        //未填写过人员信息
                        jsonObject.put("errorNo",3);
                    }
                }else{
                    //未填写过人员信息
                    jsonObject.put("errorNo",3);
                }

            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    /**
     * 提交我的身份信息
     * @param exhibi_vocation
     * @return
     */
    @RequestMapping(value = "/submitvocation" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject submitvocation(Exhibi_vocation exhibi_vocation){
        JSONObject jsonObject = new JSONObject();
        try {
            if(exhibi_vocation!=null){
                if(StringUtils.isNoneBlank(exhibi_vocation.getOpen_id())){
                    Conds conds = new Conds();
                    conds.equal("open_id",exhibi_vocation.getOpen_id());
                    conds.equal("exhibi_id",exhibi_vocation.getExhibi_id());
                    Exhibi_vocation exhibi_vocation1 = exhibi_vocationService.selectByConds(conds);
                    if(exhibi_vocation1!=null){
                        //填写过了资料信息
                        exhibi_vocation1.setVocation(exhibi_vocation.getVocation());
                        exhibi_vocation1.setExhibi_id(exhibi_vocation.getExhibi_id());
                        exhibi_vocationService.update(exhibi_vocation1);
                    }else{
                        //没填写过资料信息
                        exhibi_vocation.setStatus("0");
                        exhibi_vocationService.save(exhibi_vocation);
                    }
                }
                    jsonObject.put("errorNo",0);
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    /**
     * 提交样本资料
     * @param open_id 用户OPENID
     * @param phone 手机号码
     * @param company 公司名称
     * @param email 邮箱
     * @return
     */
    @RequestMapping(value = "/submitsample" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject submitsample(@RequestParam String open_id,@RequestParam(required = false) String phone,@RequestParam(required = false) String company,
                                   @RequestParam(required = false) String email, @RequestParam String exhibi_id,@RequestParam String accountsId){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("open_id",open_id);
            conds.equal("exhibi_id",exhibi_id);
            Exhibi_vocation exhibi_vocation = exhibi_vocationService.selectByConds(conds);
            if(exhibi_vocation!=null){
                //先填过人员信息
                exhibi_vocation.setPhone(phone);
                exhibi_vocation.setCompany(company);
                exhibi_vocation.setEmail(email);
                exhibi_vocation.setStatus("1");
                exhibi_vocationService.update(exhibi_vocation);
            }else{
                Exhibi_vocation ex = new Exhibi_vocation();
                ex.setOpen_id(open_id);
                ex.setExhibi_id(Long.valueOf(exhibi_id));
                ex.setPhone(phone);
                ex.setCompany(company);
                ex.setEmail(email);
                ex.setStatus("1");
                ex.setAccountsId(Long.valueOf(accountsId));
                exhibi_vocationService.save(ex);
            }

            jsonObject.put("errorNo",0);
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    /**
     * 判断是否填写过样本资料信息
     * @param openid 用户OPENID
     * @param exhibi_id 展会ID
     * @return
     */
    @RequestMapping(value = "/issample" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject issample(@RequestParam String openid,@RequestParam String exhibi_id){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("open_id",openid);
            conds.equal("exhibi_id",exhibi_id);
            Exhibi_vocation exhibi_vocation = exhibi_vocationService.selectByConds(conds);
            if(exhibi_vocation!=null){
                if(exhibi_vocation.getStatus().equals("1")){
                    //填写过了
                    jsonObject.put("errorNo",0);
                    jsonObject.put("company",exhibi_vocation.getCompany());
                    jsonObject.put("phone",exhibi_vocation.getPhone());
                    jsonObject.put("email",exhibi_vocation.getEmail());
                }else{
                    //未填
                    jsonObject.put("errorNo",2);
                }
            }else{
                //未填
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }
}
