package com.cftech.productdetail.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.productdetail.model.ProductDetail;
import com.cftech.productdetail.service.ProductDetailService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 产品详情Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String PRODUCTDETAIL_VIEW = "qy:productDetail:view"
 * 查看:public static final String PRODUCTDETAIL_EDIT = "qy:productDetail:edit"
 *
 * @author Buyj
 * @date: 2020-09-28 17:08
 */
@Slf4j
@Controller
@RequestMapping("/a/productDetail")
public class ProductDetailController {

    public static final String PRODUCTDETAIL_VIEW = "qy:productDetail:view";
    public static final String PRODUCTDETAIL_EDIT = "qy:productDetail:edit";

    @Autowired
    private ProductDetailService productDetailService;


    //列表页面
    @RequiresPermissions(value = PRODUCTDETAIL_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "productDetail/productDetaillist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = PRODUCTDETAIL_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            ProductDetail productDetail = productDetailService.fetchById(id);
            model.addAttribute("data", productDetail);
        }
        return "productDetail/productDetailform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = PRODUCTDETAIL_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(ProductDetail productDetail, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (productDetail != null && productDetail.getId() != null) {
                productDetail.setUpdateBy(UserUtils.getUser().getId());
                productDetailService.update(productDetail);
                rtnJson.put("errorNo", 0);
            } else {
                productDetail.setAccountsId(accountsId);
                productDetail.setDelFlag(false);
                productDetail.setAccountsId(UserUtils.getmpaccounts(request));
                productDetail.setCreateBy(UserUtils.getUser().getId());
                productDetail.setUpdateBy(UserUtils.getUser().getId());
                productDetailService.save(productDetail);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = PRODUCTDETAIL_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, ProductDetail productDetail, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("d.del_flag", Constants.DEL_FLAG_0);
        conds.equal("d.accounts_id", accountsId);
        if(!StringUtils.isEmpty(productDetail.getProductName())){
            conds.equal("d.product_name",productDetail.getProductName());
        }
        Sort sort = new Sort("d.create_time", OrderType.DESC);

        List<ProductDetail> list = productDetailService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = productDetailService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = PRODUCTDETAIL_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            productDetailService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = PRODUCTDETAIL_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<ProductDetail> list = productDetailService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(ProductDetail.class, response).toExcel(list, "产品详情信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = PRODUCTDETAIL_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(ProductDetail.class, response).toExcel(null, "产品详情信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = PRODUCTDETAIL_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue("").readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    ProductDetail productDetail = new ProductDetail();
                    productDetail.setAccountsId(accountId);
                    productDetailService.save(productDetail);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return list(request, model);
    }

}
