package com.cftech.consultsheet.service;


import com.alibaba.fastjson.JSONObject;
import com.cftech.consultsheet.model.ConsultSheet;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;

/**
* 咨询单Service
*
* @author Licc
* @date: 2020-09-22 12:06
*/
public interface ConsultSheetService extends GenericService<ConsultSheet> {

    List<ConsultSheet> fetchSearchBy(Conds conds, Sort sort, int page, int pageSize ,Long id);

    /**
     * 提交咨询单且轮询对应客服、医生进行处理
     * @param consultSheet
     */
    JSONObject pollingConsultSheet(ConsultSheet consultSheet);
}
