package com.cftech.module.activity.core.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.module.activity.core.model.ActivityBaseResultDto;
import com.cftech.module.activity.core.model.ActivityBaseResultEntity;
import com.cftech.module.activity.core.service.ActivityBaseResultService;
import com.cftech.sys.model.User;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 活动中奖纪录表Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String ACTIVITYBASERESULTENTITY_VIEW = "qy:activityBaseResultEntity:view"
 * 查看:public static final String ACTIVITYBASERESULTENTITY_EDIT = "qy:activityBaseResultEntity:edit"
 *
 * @author lisw
 * @date: 2017-04-27 11:46
 */
@Slf4j
@Controller
@RequestMapping("/a/activityBaseResultEntity")
public class ActivityBaseResultEntityController {

    public static final String ACTIVITYBASERESULTENTITY_VIEW = "qy:activityBaseResultEntity:view";
    public static final String ACTIVITYBASERESULTENTITY_EDIT = "qy:activityBaseResultEntity:edit";

    @Autowired
    private ActivityBaseResultService activityBaseResultService;


    //列表页面
    @RequiresPermissions(value = ACTIVITYBASERESULTENTITY_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "result/resultlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = ACTIVITYBASERESULTENTITY_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            ActivityBaseResultEntity activityBaseEntity = activityBaseResultService.fetchById(id);
            model.addAttribute("data", activityBaseEntity);
        }
        return "result/resultform";
    }

    //中奖记录导出
    @RequestMapping(value = "/exportExcel",method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = ACTIVITYBASERESULTENTITY_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, ActivityBaseResultEntity activityBaseResultEntity) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountId);
        if (!StringUtils.isEmpty(activityBaseResultEntity.getFrom())) {
            conds.like("from", activityBaseResultEntity.getFrom());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getActivityId())) {
            conds.equal("activity_id", activityBaseResultEntity.getActivityId());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getTitle())) {
            conds.like("title", activityBaseResultEntity.getTitle());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getOpenId())) {
            conds.like("open_id", activityBaseResultEntity.getOpenId());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrize())) {
            conds.equal("prize", activityBaseResultEntity.getPrize());
        }

        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrizeDetail())) {
            conds.like("prize_detail", activityBaseResultEntity.getPrizeDetail());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrizeType())) {
            conds.like("prize_type", activityBaseResultEntity.getPrizeType());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrizeAmount())) {
            conds.like("prize_amount", activityBaseResultEntity.getPrizeAmount());
        }
        User user = UserUtils.getUser();
        try{
            List<ActivityBaseResultDto> list = activityBaseResultService.fetchSearchByPageExport(conds,sort,0,0);
            // 生成Excel并使用浏览器下载
            ExcelKit.$Export(ActivityBaseResultDto.class, response).toExcel(list, "活动中奖记录");
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = ACTIVITYBASERESULTENTITY_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(ActivityBaseResultEntity activityBaseResultEntity, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (activityBaseResultEntity != null && activityBaseResultEntity.getId() != null) {
                activityBaseResultEntity.setUpdateBy(UserUtils.getUser().getId());
                activityBaseResultService.update(activityBaseResultEntity);
                rtnJson.put("errorNo", 0);
            } else {
                activityBaseResultEntity.setAccountsId(accountsId);
                activityBaseResultEntity.setDelFlag(false);
                activityBaseResultEntity.setAccountsId(UserUtils.getmpaccounts(request));
                activityBaseResultEntity.setCreateBy(UserUtils.getUser().getId());
                activityBaseResultEntity.setUpdateBy(UserUtils.getUser().getId());
                activityBaseResultService.save(activityBaseResultEntity);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = ACTIVITYBASERESULTENTITY_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, ActivityBaseResultEntity activityBaseResultEntity, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("result.del_flag", Constants.DEL_FLAG_0);
        conds.equal("result.accounts_id", accountsId);
        if (!StringUtils.isEmpty(activityBaseResultEntity.getFrom())) {
            conds.like("result.from", activityBaseResultEntity.getFrom());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getActivityId())) {
            conds.equal("result.activity_id", activityBaseResultEntity.getActivityId());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getTitle())) {
            conds.like("result.title", activityBaseResultEntity.getTitle());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getOpenId())) {
            conds.like("result.open_id", activityBaseResultEntity.getOpenId());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrize())) {
            conds.equal("result.prize", activityBaseResultEntity.getPrize());
        }

        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrizeDetail())) {
            conds.like("result.prize_detail", activityBaseResultEntity.getPrizeDetail());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrizeType())) {
            conds.like("result.prize_type", activityBaseResultEntity.getPrizeType());
        }
        if (!StringUtils.isEmpty(activityBaseResultEntity.getPrizeAmount())) {
            conds.like("result.prize_amount", activityBaseResultEntity.getPrizeAmount());
        }
        Sort sort = new Sort("result.create_time", OrderType.DESC);

        List<ActivityBaseResultEntity> list = activityBaseResultService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = activityBaseResultService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = ACTIVITYBASERESULTENTITY_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            activityBaseResultService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
