package com.cftech.workshop.sample.service.impl;

import com.cftech.base.codingrule.service.CodingruleService;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.security.UserUtils;
import com.cftech.workshop.sample.dao.SampleclickMapper;
import com.cftech.workshop.sample.model.Sample;
import com.cftech.workshop.sample.dao.SampleMapper;
import com.cftech.workshop.sample.model.SampleClick;
import com.cftech.workshop.sample.service.SampleService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.apache.shiro.crypto.hash.Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-06-29 13:43
 */
@Service("sampleService")
public class SampleServiceImpl extends GenericServiceImpl<Sample> implements SampleService {

    @Autowired
    @Qualifier("sampleMapper")
    private SampleMapper sampleMapper;

    @Autowired
    private SampleclickMapper sampleclickMapper;

    @Autowired
    private CodingruleUtils codingruleUtils;

    @Override
    public GenericDao<Sample> getGenericMapper() {
        return sampleMapper;
    }

    /**
     * 更新会议资料点击量和更新会议资料查看表
     * @param memberUid 会员名称
     * @param id 实体id
     */
    @Override
    public Sample updatesampleclicks(String memberUid, Long id, Long accountsId){
        Sample sample = null;
        if(StringUtils.isNoneBlank(memberUid)){
            //更新会议资料实体的点击量 点击一次  +1

            if(id!=0){
                 sample = sampleMapper.fetchById(id);
                if(sample!=null){
                    sample.setClicks(sample.getClicks()+1);
                    sampleMapper.update(sample);
                }
                //更新查看会议资料粉丝表
                Map<String, Object> params = new HashMap<String, Object>();
                Conds conds = new Conds();
                conds.equal("member_uid",memberUid);
                conds.equal("sample_id",id);
                Sort sort = new Sort("create_time", OrderType.DESC);
                params.put("conds",conds);
                params.put("sort",sort);
                List<SampleClick> list = sampleclickMapper.fetchSearchByPage(params);
                if(list.size()==0){ //如果会议资料点击查看表里面没有添加
                    SampleClick sampleClick = new SampleClick();
                    sampleClick.setNumber(codingruleUtils.getNumber(accountsId, Sample.class.getName()));
                    sampleClick.setAccountsId(accountsId);
                    sampleClick.setDelFlag(false);
                    sampleClick.setAccountsId(accountsId);
                    sampleClick.setCreateBy(UserUtils.getUser().getId());
                    sampleClick.setUpdateBy(UserUtils.getUser().getId());
                    sampleClick.setMember_uid(memberUid);
                    sampleClick.setSample_id(id);
                    sampleclickMapper.save(sampleClick);
                }

            }
        }
        return sample;
    }

}