package com.cftech.base.org.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.model.vo.QyOrgUserVO;
import com.cftech.base.org.model.vo.QyuserVO;
import com.cftech.base.org.service.OrgUnitService;
import com.cftech.base.org.service.PositionService;
import com.cftech.base.org.service.QyuserService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lisw
 * @date 2017年2月21日上午9:30:25 手机端获取人员组织Web接口
 */
@RestController
@RequestMapping("/mobile/auth/userOrg/")
public class MobileOrgUserController {

	@Autowired
	private QyuserService qyUserService;

	@Autowired
	private OrgUnitService orgUnitService;

	@Autowired
	private PositionService positionService;


	/**
	 * 根据人员获取此人下面所有存在人员的职位
	 * 
	 * @param userId
	 * @param page
	 * @param pageSize
	 * @param accountsId
	 * @param name
	 * @param positionId
	 * @param orgId
	 * @return
	 */
	@RequestMapping(value = "getPositionList", method = RequestMethod.GET, produces = { "application/json;charset=utf-8" })
	public JSONObject getPositionList(Long userId, int page, int pageSize,
			Long accountsId, String name, Long positionId, Long orgId) {
		JSONObject rtnJson = new JSONObject();
		page = page * pageSize; 
		try {
			Sort sort = new Sort("qyuser.create_time", OrderType.DESC);
			Map<String, Object> params = new HashMap<String, Object>();
			params.put("positionId", positionId);
			params.put("orgId", orgId);
			params.put("userId", userId);
			params.put("accountsId", accountsId);
			params.put("offset", page > 0 ? page : 0);
			params.put("limit", pageSize > 0 ? pageSize : 0);
			params.put("sort", sort);
			params.put("name", name);
			List<Map<String, Object>> paramsList = positionService
					.getSubordinatePostion(params);
			SimplePropertyPreFilter simplePropertyPreFilter = new SimplePropertyPreFilter(
					Map.class, "positionId", "positionName");
			String res = JSON.toJSONString(paramsList, simplePropertyPreFilter);
			rtnJson.put("data", JSON.parse(res));
			rtnJson.put("errorNo", 0);
		} catch (Exception e) {
			rtnJson.put("errorNo", 1);
		}
		return rtnJson;
	}

	/**
	 * 根据人员所有的人员
	 * 
	 * @param userId
	 * @param page
	 * @param pageSize
	 * @param accountsId
	 * @param name
	 * @param positionId
	 * @param orgId
	 * @return
	 */
	@RequestMapping(value = "getUserList", method = RequestMethod.GET, produces = { "application/json;charset=utf-8" })
	public JSONObject getPositionUserList(Long userId, int page, int pageSize,
			Long accountsId, Long positionId, Long orgId, String name) {
		JSONObject rtnJson = new JSONObject();
		try {
			Sort sort = new Sort("qyuser.create_time", OrderType.DESC);
			List<QyuserVO> list = qyUserService.getSubordinateUser(positionId,
					orgId, userId, accountsId, page, pageSize, sort, name);
			SimplePropertyPreFilter simplePropertyPreFilter = new SimplePropertyPreFilter(
					QyuserVO.class, "id", "name");
			String res = JSON.toJSONString(list, simplePropertyPreFilter);
			rtnJson.put("data", JSON.parse(res));
			rtnJson.put("errorNo", 0);
		} catch (Exception e) {
			rtnJson.put("errorNo", 1);
		}
		return rtnJson;
	}

	/**
	 * 根据人员获取下属组织及人员
	 * 
	 * @param userId
	 *            人员ID
	 * @param page
	 *            页码
	 * @param pageSize
	 *            每页获取行数
	 * @param accountsId
	 *            企业号ID
	 * @param name
	 *            组织名称搜索
	 * @return
	 */
	@RequestMapping(value = "userOrgList", method = RequestMethod.GET, produces = { "application/json;charset=utf-8" })
	public JSONObject userOrg(Long userId, int page, int pageSize,
			Long accountsId, String name, Long orgId, Long positionId) {
		JSONObject rtnJson = new JSONObject();
		try {
			page = page * pageSize;
			if (userId != null) {
				Sort sort = new Sort("create_time", OrderType.DESC);
				Map<String, Object> params = new HashMap<String, Object>();
				params.put("name", name);
				params.put("positionId", positionId);
				params.put("orgId", orgId);
				params.put("userId", userId);
				params.put("sort", sort);
				params.put("accountsId", accountsId);
				params.put("offset", page > 0 ? page : 0);
				params.put("limit", pageSize > 0 ? pageSize : 0);
				List<QyOrgUserVO> orgUserVo = qyUserService
						.getOrgSubordinateUser(params);
				rtnJson.put("data", orgUserVo);
				rtnJson.put("errorNo", 0);
			} else {
				rtnJson.put("errorNo", 2);
			}
		} catch (Exception e) {
			e.printStackTrace();
			rtnJson.put("errorNo", 1);
		}
		return rtnJson;
	}

	@RequestMapping(value = "getOrgUserList", method = RequestMethod.GET, produces = { "application/json;charset=utf-8" })
	public JSONObject getOrgUserList(Long userId, Long accountsId,
			Long[] orgIds, String positionId, Long[] userIds) {
		JSONObject rtnJson = new JSONObject();
		try {
			List<Qyuser> qyUserList = new ArrayList<Qyuser>();// 需要查询的人员
			List<Qyuser> orgUserList = new ArrayList<Qyuser>();// 需要查询的部门人员
			if (userIds != null && userIds.length > 0) {
				Conds conds = new Conds();
				conds.equal("t.accounts_id", accountsId);
				conds.equal("t.del_flag", Constants.DEL_FLAG_0);
				conds.in("t.id", userIds);
				qyUserList = qyUserService.fetchSearchByPage(conds, null, 0, 0);
			} 
			/**
			 * 筛选出所有部门下面的下级人员
			 */
			if (orgIds != null && orgIds.length > 0) {
				Map<String, Object> params = new HashMap<String, Object>();
				params.put("orgIds", orgIds);
				params.put("positionId", positionId);
				params.put("userId", userId);
				params.put("accountsId", accountsId);
				orgUserList = qyUserService.getOrgUserList(params);
			}
			outer: for (Qyuser orgUser : orgUserList) {
				for (Qyuser qyUser : qyUserList) {
					if (qyUser.getId().equals(orgUser.getId())) {// 如果部门人员在所查人员中存在，则忽略
						continue outer;
					}
				}
				Qyuser user = new Qyuser();
				user.setId(orgUser.getId());
				user.setName(orgUser.getName());
				qyUserList.add(user);
			}
			SimplePropertyPreFilter pro = new SimplePropertyPreFilter(
					Qyuser.class, "id", "name");
			String res = JSON.toJSONString(qyUserList, pro);
			rtnJson.put("data", JSON.parse(res));
			rtnJson.put("errorNo", 0);
		} catch (Exception e) {
			rtnJson.put("errorNo", 1);
		}
		return rtnJson;
	}
	
	
	/**
	 * 根据此人所在的部门，查处除自己之外的所有人员
	 * @param userId
	 * @param orgId
	 * @return
	 */
	@RequestMapping(value = "getOrgUserListNotUser", method = RequestMethod.GET, produces = { "application/json;charset=utf-8" })
	public JSONObject rtnJson(Long userId,Long orgId,int page,int pageSize){
		page=page*pageSize; 
		JSONObject rtnJson = new JSONObject();
		rtnJson.put("errorNo",0);
		try {
			Sort sort = new Sort("p.id",OrderType.ASC);
			Conds conds = new Conds();
			conds.notEqual("t.id", userId);
			conds.equal("t.del_flag", Constants.DEL_FLAG_0);
			List<QyuserVO> qyUserList = qyUserService.fetchSearchVOByPage(orgId, conds, sort, page, pageSize);
			SimplePropertyPreFilter simple = new SimplePropertyPreFilter(QyuserVO.class,"id","wxuserId","avatar","name","positionName","orgName","mobile");
			String res = JSON.toJSONString(qyUserList,simple);
			rtnJson.put("datas", JSON.parse(res));
		} catch (Exception e) {
			rtnJson.put("errorNo", 1);
		}
		return rtnJson;
	}
}
