package com.cftech.core.feature;

import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 作者 lisw:
 * @version 创建时间：2016年9月21日 下午7:42:58
 *          因apache-fileupload会与springmvc的multipartResolver冲突
 *          造成fileupload的List<FileItem>
 *          ServletFileUpload.parseRequest(request)获取不到值
 *          故需要对用到fileupload的URL做特殊处理
 *          ，凡是带upload的URL不让springmvc的multipartResolver去解析。
 * 
 *          springmvc multipartResolver配置不能去掉，否则方法将获取不到前端表单post的参数
 */
public class MyMultipartResolver extends CommonsMultipartResolver {
	private String excludeUrls;
	private String[] excludeUrlArray;

	public String getExcludeUrls() {
		return excludeUrls;
	}

	public void setExcludeUrls(String excludeUrls) {
		this.excludeUrls = excludeUrls;
		this.excludeUrlArray = excludeUrls.split(",");
	}
	
	/**
	 * Determine the encoding for the given request.
	 * Can be overridden in subclasses.
	 * <p>The default implementation checks the request encoding,
	 * falling back to the default encoding specified for this resolver.
	 * @param request current HTTP request
	 * @return the encoding for the request (never {@code null})
	 * @see javax.servlet.ServletRequest#getCharacterEncoding
	 * @see #setDefaultEncoding
	 */
	protected String determineEncoding(HttpServletRequest request) {
		String encoding = request.getCharacterEncoding();
		if (encoding == null) {
			encoding = getDefaultEncoding();
		}
		return encoding;
	}

	/**
	 * 这里是处理Multipart http的方法。如果这个返回值为true,那么Multipart http
	 * body就会MyMultipartResolver 消耗掉.如果这里返回false
	 * 那么就会交给后面的自己写的处理函数处理例如刚才ServletFileUpload 所在的函数
	 * 
	 * @see CommonsMultipartResolver#isMultipart(HttpServletRequest)
	 */
	@Override
	public boolean isMultipart(HttpServletRequest request) {
		for (String url : excludeUrlArray) {
			// 这里可以自己换判断
			if (request.getRequestURI().contains(url)) {
				return false;
			}
		}
		return super.isMultipart(request);
	}

}
