var side = (function () {
  'use strict';

  var Side = function (params) {
    var p = this;
    p.params = {
      targetId: '.container', //插入side组件的div
      currentIndex: '', //当前选择第几个菜单
      dataApi: G.baseUri() + '/mobile/auth/workshop/getpeopledetails',
      agendaApi: G.baseUri() + '/mobile/auth/agenda/selectmeetingstatus',
      //dataApi: 'json/side.json',
      menu: {},
      cfApp: null,
    };
    var getQueryString = function (name) {
      var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
      var r = window.location.search.substr(1).match(reg);
      if (r != null) return decodeURI(r[2]);
      return null;
    };

    p.id = getQueryString('id');
    p.appid = getQueryString('appid');
    p.english = getQueryString('english') == 1 ? true : false;
    console.log(p.english);

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    p.init = function () {
      console.log(1);
      loadData();
      //insertHtml();
      controlSide();
      linkEvent();

    }

    var loadData = function () {
      var formdata = {
        member_uid: cfApp.getMpInfo().memberId,
        meetingId: getQueryString("id")
      }
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {

        console.log(retdata);
        var avatar = retdata.imgurl;
        var suname = retdata.suname;

        var name = retdata.name;
        if (retdata.menu) {
          p.params.menu = retdata.menu;
        }
        insertHtml(avatar, suname, name, p.params.menu);


      });
    }


    var sideTemplate = function (img, last, first, menu) {
      if(p.english){
        var HeaderTemplate = '<div class="header align-center">' +
            '<img src="image/menuen.png" class="menu" id="menu" align="middle">'+
            // '<div class="menu-font" style="display: none"><font  size="2">Menu</font></div>' +
            '<img src="image/logo.png" class="logo">' +
            '</div>';
      }else{
        var HeaderTemplate = '<div class="header align-center">' +
            '<img src="image/menucn.png" class="menu" id="menu" align="middle">'+
            // '<div class="menu-font" style="display: none"><font  size="2">菜单</font></div>' +
            '<img src="image/logo.png" class="logo">' +
            '</div>';
      }


      var SideTemplate = '<div class="sidebar f14" id="sidebar">' +
        '<div class="sidebar-header align-center">' +
        '<img src="' + img + '" alt="">' +
        '<div>' +
        '<p>' + last + first + '</p>' +
        '<img src="image/edit.png" alt="" id="edit">' +
        '</div>' +
        '</div>' +
        '<ul class="sidebar-list">';

      SideTemplate += '<li class="side1" id="overview"  data-index="1">' +
          '<p>活动概览</p>' +
          '</li>';
      if (menu.agenda_count > 0) {
        SideTemplate += '<li class="side1" id="agenda"  data-index="0">' +
           '<p>活动议程</p>' +
            //'<p>技术演讲</p>' +
          '</li>';
      }
      /*if (menu.speech_count > 0) {
        SideTemplate += '<li class="side2" id="speaker" data-index="1">' +
          '<p>演讲嘉宾</p>' +
          '</li>';
      }*/
      if (menu.sample_count > 0) {
        SideTemplate += '<li class="side3" id="material" data-index="2">' +
          '<p >展品信息</p>' +
          '</li>';
      }
      if (menu.takedrive_count > 0) {
        SideTemplate += '<li class="side4" id="test"  data-index="3">' +
          '<p>试驾车辆</p>' +
          '</li>';
      }
      if (menu.activity_count > 0) {
        SideTemplate += '<li class="side5" id="interaction"  data-index="4">' +
          '<p>现场互动</p>' +
          '</li>';
      }
      if (menu.album_count > 0) {
        SideTemplate += '<li class="side6" id="photo"  data-index="5">' +
          '<p>相册集</p>';
      }

      if(menu.is_questions=='0'){
          SideTemplate += '<li class="side11" id="screen"  data-index="10">' +
              '<p>现场提问</p>';
      }



      if (menu.paper_count > 0) {
        SideTemplate += '</li>' +
          '<li class="side7" id="feedback"  data-index="6">' +
          '<p>意见反馈</p>' +
          '</li>';
      }

      SideTemplate += '</ul>' +
        '<hr/>' +
        '<ul class="sidebar-list">' +
        '<li class="side8" id="schedule-list"  data-index="7">' +
        '<p>我的行程</p>' +
        '</li>' +
        '<li class="side9" id="qrcode"  data-index="8">' +
        '<p>签到二维码</p>' +
        '</li>' +
        '<li class="side10" id="schedule-form"  data-index="9">' +
          '<p>行程提交/修改</p>' +
        '</li>' +
        '</ul>' +
        '</div>';


      var SideTemplateEnglish = '<div class="sidebar f14" id="sidebar">' +
        '<div class="sidebar-header align-center">' +
        '<img src="' + img + '" alt="">' +
        '<div>' +
        '<p>' + last + first + '</p>' +
        '<img src="image/edit.png" alt="" id="edit">' +
        '</div>' +
        '</div>' +
        '<ul class="sidebar-list">';
      SideTemplateEnglish += '<li class="side1" id="overview"  data-index="1">' +
          '<p>Program Overview</p>' +
          '</li>';

      if (menu.agenda_count > 0) {
        SideTemplateEnglish+= '<li class="side1" id="agenda"  data-index="0">' +
        //'<p>Presentations</p>' +
        '<p>Event Agenda</p>' +
        '</li>';
      }
      /*if (menu.speech_count > 0) {
        SideTemplateEnglish+= '<li class="side2" id="speaker"  data-index="1">' +
            '<p>Speakers</p>' +
            '</li>';
      }*/
      if (menu.sample_count > 0) {
        SideTemplateEnglish+='<li class="side3" id="material"  data-index="2">' +
            '<p>Exhibits info</p>' +
            '</li>';
      }
      if (menu.takedrive_count > 0) {
        SideTemplateEnglish+='<li class="side4" id="test"  data-index="3">' +
            '<p>Demo vehicles</p>' +
            '</li>';
      }
      if (menu.activity_count > 0) {
        SideTemplateEnglish+= '<li class="side5" id="interaction"  data-index="4">' +
            '<p>Onsite interaction</p>' +
            '</li>';
      }
      if (menu.album_count > 0) {
        SideTemplateEnglish+=  '<li class="side6" id="photo"  data-index="5">' +
        '<p>Photo Gallery</p>' +
        '</li>';
      }


        if (menu.is_questions == 0) {
            SideTemplateEnglish+=  '<li class="side11" id="screen"  data-index="10">' +
                '<p>Q&A</p>' +
                '</li>'
        }



      if (menu.paper_count > 0) {
        SideTemplateEnglish+=  '<li class="side7" id="feedback"  data-index="6">' +
        '<p>Satisfaction survey</p>' +
        '</li>'
      }

      SideTemplateEnglish+= '</ul>' +
        '<hr/>' +
        '<ul class="sidebar-list">' +
        '<li class="side8" id="schedule-list"  data-index="7">' +
        '<p>My schedule</p>' +
        '</li>' +
        '<li class="side9" id="qrcode"  data-index="8">' +
        '<p>Onsite registration code</p>' +
        '</li>' +
        '<li class="side10" id="schedule-form"  data-index="9">' +
        '<p>Submit/Modify schedule</p>' +
        '</li>' +
        '</ul>' +
        '</div>';
      var bgTemplate = '<div id="bg" class="display"></div>';
      if (p.english) {
        return HeaderTemplate + SideTemplateEnglish + bgTemplate;
      } else {
        return HeaderTemplate + SideTemplate + bgTemplate;
      }


    }


    var insertHtml = function (a, s, n, l) {
      $(p.params.targetId).append(sideTemplate(a, s, n, l));
      if (p.params.currentIndex && p.params.currentIndex != '') {
        $('.sidebar li[data-index='+p.params.currentIndex +']').addClass('choose');
      }

    }

    var controlSide = function () {


      //点击菜单图标收缩side
      $('body').on('click', '#menu', function () {
        $('#bg').toggleClass('display')
        $('#sidebar').toggleClass('show')
      });

      //点击bg关闭side；
      $('body').on('click', '#bg', function () {
        $('#bg').addClass('display')
        $('#sidebar').removeClass('show')
      });
      // $('.sidebar-list li').click(function(){
      //     $('.sidebar-list li').removeClass('choose');
      //     $(this).addClass('choose')
      // })

    }

    var linkEvent = function () {
      //活动议程
      $('body').on('click', '#agenda', function () {
      var formdata = {
        "meetingId":getQueryString("id")
      }
        G.ajax('get', p.params.agendaApi, formdata, function (retdata) {
if(retdata.errorNo==3){

  if (p.english) {
    location.href = 'agenda-special-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
  } else {
    location.href = 'agenda-special.html?appid=' + p.appid + '&id=' + p.id;
  }

}else if(retdata.errorNo==4){
  if (p.english) {
    location.href = 'activity-agenda-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
  } else {
    location.href = 'activity-agenda.html?appid=' + p.appid + '&id=' + p.id;
  }
}



        });





        

      });
      //演讲嘉宾
      $('body').on('click', '#speaker', function () {
        if (p.english) {
          location.href = 'guest-speaker-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'guest-speaker.html?appid=' + p.appid + '&id=' + p.id;
        }

      });

      //活动概览
      $('body').on('click', '#overview', function () {
        if (p.english) {
          location.href = 'overview-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'overview.html?appid=' + p.appid + '&id=' + p.id;
        }

      });

      //会议资料
      $('body').on('click', '#material', function () {
        if (p.english) {
          location.href = 'meeting-material-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'meeting-material.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //试驾信息
      $('body').on('click', '#test', function () {
        if (p.english) {
          location.href = 'test-drive-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'test-drive.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //现场互动
      $('body').on('click', '#interaction', function () {
        if (p.english) {
          location.href = 'interaction-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'interaction.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //相册集
      $('body').on('click', '#photo', function () {
        if (p.english) {
          location.href = 'photo-album-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'photo-album.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //意见反馈
      $('body').on('click', '#feedback', function () {
        if (p.english) {
          location.href = 'feedback-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'feedback.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //现场投屏
      $('body').on('click','#screen',function(){
        if(p.english){
          location.href = 'meeting-screen-english.html?appid='+p.appid + '&id='+p.id + '&english=1';
        }else{
          location.href = 'meeting-screen.html?appid='+p.appid+'&id='+p.id;
        }
      })
      //我的行程
      $('body').on('click', '#schedule-list', function () {
        if (p.english) {
          location.href = 'my-schedule-list-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'my-schedule-list.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //签到二维码
      $('body').on('click', '#qrcode', function () {
        if (p.english) {
          location.href = 'qrcode-sign-in-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'qrcode-sign-in.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //行程修改
      $('body').on('click', '#schedule-form', function () {
        if (p.english) {
          location.href = 'my-schedule-form-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1';
        } else {
          location.href = 'my-schedule-form.html?appid=' + p.appid + '&id=' + p.id;
        }

      });
      //修改个人信息
      $('body').on('click', '#edit', function () {
        if (p.english) {
          location.href = 'edit-information-english.html?appid=' + p.appid + '&id=' + p.id + '&english=1'+"&redirectURL="+encodeURIComponent(location.href);
        } else {
          location.href = 'edit-information.html?appid=' + p.appid + '&id=' + p.id+"&redirectURL="+encodeURIComponent(location.href);
        }

      });



    }
  };





  return Side;
})();