package com.cftech.sys.service;

import com.cftech.sys.model.Role;
import com.cftech.sys.model.UserRole;

import java.util.List;

/**
 * 角色 业务接口
 * 
 * @author StarZou
 * @since 2014年6月10日 下午4:15:01
 **/
public interface RoleService{
    /**
     * 通过用户id 查询用户 拥有的角色
     * 
     * @param userId
     * @return
     */
    List<UserRole> selectRolesByUserId(Long userId);
    
    Role getByPrimaryKey(Long id);
    
    List<Role> selectAll(String roleName);

    
    void insertRole(Role r);
    
    void updateRole(Role r);
    
    List<Role> getRoleByIds(String roleids);
    /**
     * 通过用户id,公众号ID 查询拥有的角色
     * 
     * @param id
     * @return
     */
    List<UserRole> selectRolesByUserAccountsId(Long userId, Long accountsId);
    /**
     * 通过公众号ID查询拥有的角色
     * 
     * @param id
     * @return
     */
    List<UserRole> selectRolesByAccountsId(Long accountId);
    
    /**
     *通过角色编码，搜索出对应角色 
     */
    List<Role> selectAllSign(String roleSign);
    
}
