package com.cftech.common.commondept.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.common.commondept.model.CommonDepartment;
import com.cftech.common.commondept.service.CommonDepartmentService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 通用申请单部门Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String COMMONDEPARTMENT_VIEW = "qy:commonDepartment:view"
 * 查看:public static final String COMMONDEPARTMENT_EDIT = "qy:commonDepartment:edit"
 *
 * @author faye
 * @date: 2019-08-14 17:08
 */
@Slf4j
@Controller
@RequestMapping("/a/commonDepartment")
public class CommonDepartmentController {

    public static final String COMMONDEPARTMENT_VIEW = "qy:commonDepartment:view";
    public static final String COMMONDEPARTMENT_EDIT = "qy:commonDepartment:edit";

    @Autowired
    private CommonDepartmentService commonDepartmentService;


    //列表页面
    @RequiresPermissions(value = COMMONDEPARTMENT_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,String typeform) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        if(StringUtils.isEmpty(typeform)){
            typeform="1";
        }
        model.addAttribute("id", typeform);
        return "commonDepartment/commonDepartmentlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = COMMONDEPARTMENT_EDIT)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model,String typeform) {
        if (!StringUtils.isEmpty(id)) {
            CommonDepartment commonDepartment = commonDepartmentService.fetchById(id);
            model.addAttribute("data", commonDepartment);
        }
        model.addAttribute("typeform", typeform);
        return "commonDepartment/commonDepartmentform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = COMMONDEPARTMENT_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(CommonDepartment commonDepartment, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (commonDepartment != null && commonDepartment.getId() != null) {
                commonDepartment.setUpdateBy(UserUtils.getUser().getId());
                commonDepartmentService.update(commonDepartment);
                rtnJson.put("errorNo", 0);
            } else {
                commonDepartment.setAccountsId(accountsId);
                commonDepartment.setDelFlag(false);
                commonDepartment.setAccountsId(UserUtils.getmpaccounts(request));
                commonDepartment.setCreateBy(UserUtils.getUser().getId());
                commonDepartment.setUpdateBy(UserUtils.getUser().getId());
                commonDepartmentService.save(commonDepartment);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = COMMONDEPARTMENT_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, CommonDepartment commonDepartment, HttpServletRequest request, String isKey) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("cd.del_flag", Constants.DEL_FLAG_0);
        conds.equal("cd.accounts_id", accountsId);
        if (!StringUtils.isEmpty(commonDepartment.getSort())) {
            conds.like("cd.sort", commonDepartment.getSort());
        }
        if(!StringUtils.isEmpty(commonDepartment.getName())){
            conds.like("cd.name", commonDepartment.getName());
        }
        if(commonDepartment.getTypeform()!=null){
            conds.equal("cd.typeform",commonDepartment.getTypeform());
        }
        Sort sort = new Sort("cd.create_time", OrderType.DESC);
        List<CommonDepartment> list = commonDepartmentService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = commonDepartmentService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = COMMONDEPARTMENT_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            commonDepartmentService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = COMMONDEPARTMENT_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,CommonDepartment commonDepartment) {
        Long accountId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("cd.del_flag", Constants.DEL_FLAG_0);
        conds.equal("cd.accounts_id", accountId);
        if (!StringUtils.isEmpty(commonDepartment.getSort())) {
            conds.like("cd.sort", commonDepartment.getSort());
        }
        if(commonDepartment.getTypeform()!=null){
            conds.equal("cd.typeform",commonDepartment.getTypeform());
        }
        if(!StringUtils.isEmpty(commonDepartment.getName())){
            conds.like("cd.name", commonDepartment.getName());
        }
        Sort sort = new Sort("cd.create_time", OrderType.DESC);
        List<CommonDepartment> list = commonDepartmentService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(CommonDepartment.class, response).toExcel(list, "促销品申请单部门信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = COMMONDEPARTMENT_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(CommonDepartment.class, response).toExcel(null, "促销品申请单部门信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = COMMONDEPARTMENT_EDIT)
    @ResponseBody
    public JSONObject importExcel(HttpServletRequest request, MultipartFile file, Model model,Long id) {
        Long accountId = UserUtils.getmpaccounts(request);
        JSONObject retJson = new JSONObject();
        if (file == null) {
            retJson.put("errorNo", "1");
            retJson.put("errorMsg", "未选择导入文件");
            return retJson;
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    CommonDepartment commonDepartment = new CommonDepartment();
                    commonDepartment.setAccountsId(accountId);
                    commonDepartment.setName(rowData.get(0));
                    commonDepartment.setTypeform(id);
                    commonDepartment.setSort(rowData.get(1));
                    commonDepartmentService.save(commonDepartment);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }
        retJson.put("errorNo", "0");
        retJson.put("errorMsg", "导入成功");
        return retJson;
    }

}
