package com.cftech.mp.reply.service;

import com.cftech.core.util.OKHttpUtils;
import com.cftech.core.util.SystemConfig;
import com.cftech.mp.reply.model.MobileLog;
import lombok.extern.slf4j.Slf4j;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by kingdee-001 on 2018/6/20.
 */
@Component
@Slf4j
public class AsyncService {

    private static final String logUrl = SystemConfig.p.getProperty("LOG_URL");

    @Async
    public void deductInventory(MobileLog mobileLog, HttpServletRequest request) {
        Map<String,Object> params = ConvertObjToMap(mobileLog);
        String res =OKHttpUtils.sendPost(logUrl,params);
    }


    public static Map ConvertObjToMap(Object obj){
        Map<String,Object> reMap = new HashMap<String,Object>();
        if(obj == null){
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        try {
            for(int i=0;i<fields.length;i++){
                try {
                    Field f = obj.getClass().getDeclaredField(fields[i].getName());
                    f.setAccessible(true);
                    Object o = f.get(obj);
                    reMap.put(fields[i].getName(), o);
                } catch (NoSuchFieldException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        } catch (SecurityException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return reMap;
    }
}
