package com.cftech.mp.wechat.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 * wx_mp_menu 实体类
 * Created by lisw 31/10/2016.
 */ 
@Data
@NoArgsConstructor
public class Menu implements Serializable {
	/**
	 * id
	 */
	private Long id;

	/**
	 * 菜单名称
	 */
	private String name;

	/**
	 * 点击事件  1:固定返回 2:访问链接
	 */
	private String sourceType;

	/**
	 * source_type为1时才有值 1:文本消息 2:图文消息
	 */
	private String msgType;

	/**
	 * source_type为1时：msg_type为1时此值为文本内容，msg_type为2时此值为图文ID集。
	 * source_type为2时此值为URL链接
	 */
	private String sourceContent;

	/**
	 * sort
	 */
	private Integer sort;

	/**
	 * createTime
	 */
	private Timestamp createTime;

	/**
	 * updateTime
	 */
	private Timestamp updateTime;

	/**
	 * createBy
	 */
	private Long createBy;

	/**
	 * updateBy
	 */
	private Long updateBy;

	/**
	 * delFlag
	 */
	private String delFlag;
	
	/**
	 * 公众号ID
	 */
	private Long accountsid;
	
	/**
	 * 父级菜单ID
	 */
	private Long parentId;
	
	/**
	 * 父级菜单名字
	 */
	private String parentName;
	
	private List<Menu> children = new ArrayList<Menu>();

	/**
	 * 微信图文Item
	 */
	private String newsItem;

	/**
	 * 文章图文标题
	 */
	private String localNews;



}