package com.cftech.cos.qiniu;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import com.cftech.cos.core.CosService;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by liuling on 2017/5/3.
 */
@Slf4j
public class QiniuStorageService implements CosService {

    public static Auth getAuth(Cosconfig cosconfig) {
        Auth auth = Auth.create(cosconfig.getKeyId(), cosconfig.getKeySecret());
        return auth;
    }

    public static UploadManager getUploadManager() {
        Zone z = Zone.autoZone();
        Configuration c = new Configuration(z);
        UploadManager uploadManager = new UploadManager(c);
        return uploadManager;
    }

    public static String getUploadToken(Cosconfig cosconfig, Auth auth) {
        return auth.uploadToken(cosconfig.getBucket());
    }

    public static BucketManager getBucketManager(Auth auth) {
        Zone z = Zone.autoZone();
        Configuration c = new Configuration(z);
        BucketManager bucketManager = new BucketManager(auth, c);
        return bucketManager;
    }


    @Override
    public JSONObject uploadFile(Cosconfig cosconfig, byte[] data, String path) {
        JSONObject jsonObject = new JSONObject();

        Auth auth = getAuth(cosconfig);
        UploadManager uploadManager = getUploadManager();

        log.info("ready to uploadFile: {}", path);
        try {
            Response res = uploadManager.put(data, path, getUploadToken(cosconfig, auth));
            String resBody = res.bodyString();
            if (!res.isOK()) {
                log.error(resBody);
                jsonObject.put("code", "1");
                jsonObject.put("message", resBody);
                return jsonObject;
            } else {
                log.info("uploadFile: {}, result: {}", path, resBody);
                jsonObject.put("code", "0");
                jsonObject.put("message", resBody);
                return jsonObject;
            }
        } catch (QiniuException e) {
            return handleQiniuException(e);
        }
    }

    @Override
    public JSONObject uploadFile(Cosconfig cosconfig, InputStream inputStream, String path) {
        JSONObject jsonObject = new JSONObject();
        try {
            return uploadFile(cosconfig, IOUtils.toByteArray(inputStream), path);
        } catch (IOException e) {
            log.error(e.getMessage());
            jsonObject.put("code", "1");
            jsonObject.put("message", e.getMessage());
            return jsonObject;
        }
    }

    @Override
    public JSONObject deleteFile(Cosconfig cosconfig, String key) {
        JSONObject jsonObject = new JSONObject();
        log.info("ready to delete file : {}", key);
        Auth auth = getAuth(cosconfig);
        BucketManager bucketManager = getBucketManager(auth);
        try {
            Response res = bucketManager.delete(cosconfig.getBucket(), key);
            String resBody = res.bodyString();
            log.info("delete file : {}, result: {}", key, resBody);
            jsonObject.put("code", "0");
            jsonObject.put("message", resBody);
            return jsonObject;
        } catch (QiniuException e) {
            return handleQiniuException(e);
        }
    }

    public static JSONObject handleQiniuException(QiniuException e) {
        JSONObject jsonObject = new JSONObject();
        Response r = e.response;
        log.error(r.toString());
        jsonObject.put("code", "1");
        jsonObject.put("message", r.toString());
        return jsonObject;
    }
}
