var UserAdd = function () {

    var initForm = function () {
        var initFormCtrl = function () {
            bindEvent();
        };
        function passwordLevel(password) {
            var Modes = 0;
            for (i = 0; i < password.length; i++) {
                Modes |= CharMode(password.charCodeAt(i));
            }
            return bitTotal(Modes);

            //CharMode函数
            function CharMode(iN) {
                if (iN >= 48 && iN <= 57)//数字
                    return 1;
                if (iN >= 65 && iN <= 90) //大写字母
                    return 2;
                if ((iN >= 97 && iN <= 122) || (iN >= 65 && iN <= 90)) //大小写
                    return 4;
                else
                    return 8; //特殊字符
            }

            //bitTotal函数
            function bitTotal(num) {
                modes = 0;
                for (i = 0; i < 4; i++) {
                    if (num & 1) modes++;
                    num >>>= 1;
                }
                return modes;
            }
        }

        $.validator.addMethod("strongPsw",function(value,element){
            if(!value||value=='')
            {
                return true;
            }
            if(passwordLevel(value)==3||passwordLevel(value)==4){return true;}
            return false;
        },"8位以上，需同时包含大写、小写及数字");

        var bindEvent = function() {
            $("#roleform").validate({
                rules: {
                	username: {
                        required: true,
                        htmlescape: true
                    },
                    password: {
                        htmlescape: true
                    },
                    newpassword: {
                        htmlescape: true,
                        minlength:8,    //最小长度
                        maxlength:50,   //最大长度
                        strongPsw:true  //密码强度
                    }
                },
                messages: {
                	confirmNewPassword: {equalTo: "输入与上面相同的密码"},
                    password: {
                        htmlescape: "请您不要输入特殊字符!"
                    },
                    newpassword: {
                        htmlescape: "请您不要输入特殊字符!"
                    },
                    confirmNewPassword: {
                        htmlescape: "请您不要输入特殊字符!"
                    }
                },
                submitHandler: function (form) 
                {
                	var password;
                	var newpassword;
                	if($("#password").val()!=null&&$("#password").val()!='')
                	{
                		password = sha256_digest($("#password").val());
                	}
                	
                	if($("#confirmNewPassword").val()!=null && $("#confirmNewPassword").val()!='')
                	{
                		newpassword = sha256_digest($("#confirmNewPassword").val());
                	}
                    var formdata = 
                    {
                        password:password,
                        newpassword:newpassword
                    };
                   // console.log(formdata);
                    formSubmit(formdata);
                }
        }); }

        initFormCtrl();
    };

    return {

        //main function to initiate the module
        init: function () {
            initForm();
        }

    };

}();