package com.cftech.reportform.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.reportform.model.ReportForm;
import com.cftech.reportform.service.ReportFormService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 报表管理Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String REPORTFORM_VIEW = "qy:reportForm:view"
 * 查看:public static final String REPORTFORM_EDIT = "qy:reportForm:edit"
 *
 * @author Licc
 * @date: 2020-10-16 14:33
 */
@Slf4j
@Controller
@RequestMapping("/a/reportForm")
public class ReportFormController {

    public static final String REPORTFORM_VIEW = "qy:reportForm:view";
    public static final String REPORTFORM_EDIT = "qy:reportForm:edit";

    @Autowired
    private ReportFormService reportFormService;


    //列表页面
    @RequiresPermissions(value = REPORTFORM_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "reportForm/reportFormlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = REPORTFORM_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            ReportForm reportForm = reportFormService.fetchById(id);
            model.addAttribute("data", reportForm);
        }
        return "reportForm/reportFormform";
    }

//    //提交数据（新增、修改）
//    @RequiresPermissions(value = REPORTFORM_EDIT)
//    @RequestMapping("/formData")
//    @ResponseBody
//    public JSONObject formData(ReportForm reportForm, Model model, HttpServletRequest request) {
//        Long accountsId = UserUtils.getmpaccounts(request);
//        JSONObject rtnJson = new JSONObject();
//        try {
//            if (reportForm != null && reportForm.getId() != null) {
//                reportForm.setUpdateBy(UserUtils.getUser().getId());
//                reportFormService.update(reportForm);
//                rtnJson.put("errorNo", 0);
//            } else {
//                reportForm.setAccountsId(accountsId);
//                reportForm.setDelFlag(false);
//                reportForm.setAccountsId(UserUtils.getmpaccounts(request));
//                reportForm.setCreateBy(UserUtils.getUser().getId());
//                reportForm.setUpdateBy(UserUtils.getUser().getId());
//                reportFormService.save(reportForm);
//                rtnJson.put("errorNo", 2);
//            }
//        } catch (Exception e) {
//            rtnJson.put("errorNo", 1);
//        }
//        return rtnJson;
//    }

    //获取列表数据
    @RequiresPermissions(value = REPORTFORM_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, ReportForm reportForm, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("o.del_flag", Constants.DEL_FLAG_0);
        conds.equal("o.accounts_id", accountsId);
        if (!org.apache.commons.lang3.StringUtils.isEmpty(reportForm.getCustomerName())) {
            conds.like("t.`name`", reportForm.getCustomerName());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(reportForm.getPharmacist())) {
            conds.like("q.`name`", reportForm.getPharmacist());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(reportForm.getNumber())) {
            conds.like("o.number", reportForm.getNumber());
        }
        Sort sort = new Sort("o.create_time", OrderType.DESC);
        List<ReportForm> list = reportFormService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = reportFormService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = REPORTFORM_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            reportFormService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = REPORTFORM_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("o.del_flag", 0);
        conds.equal("o.accounts_id", accountId);
        List<ReportForm> list = reportFormService.fetchSearchByPage(conds, null, 0, 0);
        ExcelKit.$Export(ReportForm.class, response).toExcel(list, "报表管理信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = REPORTFORM_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(ReportForm.class, response).toExcel(null, "报表管理信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = REPORTFORM_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue("").readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    ReportForm reportForm = new ReportForm();
                    reportForm.setAccountsId(accountId);
                    reportFormService.save(reportForm);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return list(request, model);
    }

}
