package com.cftech.productclassify.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.productclassify.model.Productclassify;
import com.cftech.core.generic.GenericService;
import com.cftech.productclassify.model.ProductclassifyDto;

import java.util.List;
import java.util.Map;

/**
* 产品分类Service
*
* @author Buyj
* @date: 2020-09-22 18:06
*/
public interface ProductclassifyService extends GenericService<Productclassify> {

    /**
     * 查找产品分类
     * @param conds
     * @param sort
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<Productclassify> fetchTreeByPage(Conds conds , Sort sort,int pageNo , int pageSize);
    /**
     *
     * @Description  商品列表展示
     * @Date 15:16 2020/10/21
     * @Param
     * @return
     **/
    JSONObject productList(ProductclassifyDto productclassifyDto);
    /**
     *
     * @Description  商品分类菜单数据回填
     * @Date 15:16 2020/10/21
     * @Param
     * @return
     **/
    JSONObject productMenu(String appId);

//    /**
//     *
//     * @Description  商品分类菜单剂型回填
//     * @Date 15:16 2020/10/21
//     * @Param
//     * @return
//     **/
//    JSONObject productMenu(String appId,String dosageName);
    /**
     * @Author Licc
     * @Description  热门推荐
     * @Date 19:41 2020/11/2
     * @Param [appId] 
     * @return com.alibaba.fastjson.JSONObject
     **/
    JSONObject hotproduct(String appId);
    /**
     * @Author Licc
     * @Description  好药推荐
     * @Date 19:42 2020/11/2
     * @Param [appId] 
     * @return com.alibaba.fastjson.JSONObject
     **/
    JSONObject medicine(String appId);
    /**
     * 根据分类编码查分类ID
     * @param classifyNumber
     * @return
     */
    String selectIdsByNumber(String classifyNumber);
    /**
     *
     * @Description  商品分类菜单剂型回填
     * @Date 15:16 2020/10/21
     * @Param
     * @return
     **/
    JSONObject productDosage(String appId, String dosageName);
}
