var meetingIntro = (function () {
  'use strict';
  var MeetingIntro = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/workshop/getworkshopdetails',
      isJoinApi: G.baseUri() + '/mobile/auth/workshop/isregis',
      joinApi: G.baseUri() + '/mobile/auth/workshop/isjoinmeeting',
      invitecode:'',

      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/meeting-intro.json';
      p.params.isJoinApi = 'json/code.json';
      p.params.joinApi = 'json/code.json';


    }
    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        p.params.invitecode = cfApp.getQueryString('invitcode');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {
        var sideDiv = new side({
          currentIndex: '1',
          cfApp:cfApp

        });
        sideDiv.init();


        log();
        loadData();

        $('.language').click(function () {
          if (!p.english) {
            if(p.params.invitecode) {
              location.href = 'overview.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1&invitcode='+p.params.invitecode;
            }else{
              location.href = 'overview-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
            }
          } else {
            if(p.params.invitecode) {
              location.href = 'overview.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+"&invitcode="+p.params.invitecode;
            }else{
              location.href = 'overview.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
            }

          }

        });

        return true;
      } else {
        return false;
      }
    };
    var initInfinite = function () {
      $('body').infinite().on("infinite", function () {
        if (p.loading) return;
        p.loading = true;

        setTimeout(function () {

          loadData();

        }, 800);
      });
    };

    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "研讨会",
        modulename: "会议简介",
        keyword: "会议简介",
        keywordid: cfApp.getQueryString('id'),
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {


      var formdata = {
        member_uid: p.empInfo.memberId,
        meetingId:cfApp.getQueryString("id")
      }
      G.ajax('get', p.params.isJoinApi, formdata, function (retdata) {
        if (retdata.errorNo == '4') {
          if(!p.params.invitecode) {//
            location.href = "invitation-code.html?appid=" + p.params.appid + "&meetingId=" + cfApp.getQueryString("id");
          }else{
            loadDataTemp();
          }
        }else{//已报名
          loadDataTemp();
        }
    })
    }


    var loadDataTemp =  function(){
      if(p.english){
        $.showLoading("Loading");
      }else{
        $.showLoading();
      }

      $("body").show();
      var formdata = {
        meetingId: cfApp.getQueryString('id')
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        if (retdata.errorNo == '0') {
          console.log(retdata);
          var content = $('#template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata.data);
          $('.content').append(htmlStr);
          event();
        }
      });
    }

    var event = function () {
      $('#submit').click(function () {


        var formdata = {
          member_uid: p.empInfo.memberId,
          meetingId:cfApp.getQueryString("id")
        }
        G.ajax('get', p.params.isJoinApi, formdata, function (retdata) {
          if (retdata.errorNo == '4') {

            if(!p.params.invitecode){//
              location.href="invitation-code.html?appid="+p.params.appid+"&meetingId="+cfApp.getQueryString("id");
            }else{
              //是否参加会议
              $.modal({
                title: "",
                text: '<span style="color:#000">我参加此活动！</span>',
                buttons: [{
                  text: "不",
                  className: "leftBtn"
                },
                  {
                    text: "是",
                    onClick: function () {

                      var formdata = {
                        member_uid: p.empInfo.memberId,
                        ivitecode:p.params.invitecode
                      }
                      G.ajax(G.devModePost, p.params.joinApi, formdata, function (retdata) {
                        if (retdata.errorNo == '0') {
                          if (p.english) {
                            location.href = 'activity-agenda-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&modal=1' + '&english=1';
                          } else {
                            location.href = 'activity-agenda.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&modal=1';
                          }
                        } else  {
                          $.modal({
                            title: "",
                            text: '<span class="color-green">参数错误！</span></br>System error',
                            buttons: [{
                              text: "确定OK"
                            }]
                          });
                        }
                      });
                    }
                  }
                ]
              });
            }


          } else if (retdata.errorNo == '3') {
            if (p.english) {
              location.href = 'my-schedule-list-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
            } else {
              location.href = 'my-schedule-list.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
            }

          }



        });
      });
    }


  };

  return MeetingIntro;
})();