package com.cftech.questionnaire.core.paper.model;

import com.cftech.core.poi.ExportConfig;
import com.cftech.core.util.DateUtils;
import lombok.Data;

import java.util.Date;

/**
 * Created by lisw on 2018/7/13.
 */

public class PaperLogDto {

    private Long paperId;

    @ExportConfig(value = "问卷标题", width = 100)
    private String paperTitle;

    @ExportConfig(value = "题目标题", width = 100)
    private String subjectName;

    @ExportConfig(value = "答案", width = 100)
    private String optionName;


    private String optionCon;

    @ExportConfig(value = "会员名", width = 100)
    private String memberName;

    @ExportConfig(value = "会员姓", width = 100)
    private String surMemberName;

    @ExportConfig(value = "题目类型", width = 100)
    private String subjectType;

    @ExportConfig(value = "提交时间", width = 100)
    private String createDateStr;

    @ExportConfig(value = "序号",width = 100)
    private Long sort;

    @ExportConfig(value = "客户分类",width = 100)
    private String peopletype;

    private Date createTime;

    public Long getPaperId() {
        return paperId;
    }

    public void setPaperId(Long paperId) {
        this.paperId = paperId;
    }

    public String getPaperTitle() {
        return paperTitle;
    }

    public void setPaperTitle(String paperTitle) {
        this.paperTitle = paperTitle;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getOptionName() {
        return optionName;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public String getOptionCon() {
        return optionCon;
    }

    public void setOptionCon(String optionCon) {
        this.optionCon = optionCon;

    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getSurMemberName() {
        return surMemberName;
    }

    public void setSurMemberName(String surMemberName) {
        this.surMemberName = surMemberName;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
        if("BLANKFILL".equals(this.subjectType)){
            this.subjectType="填空题";
        }else if("SINGLESEL".equals(this.subjectType)){
            this.subjectType="单选题";
        }else if("MULTISEL".equals(this.subjectType)){
            this.subjectType="多选题";
        }
    }

    public String getCreateDateStr() {
        return createDateStr;
    }

    public void setCreateDateStr(String createDateStr) {
        this.createDateStr = createDateStr;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
        this.createDateStr= DateUtils.formatDate(createTime,"yyyy-MM-dd HH:mm:ss");
    }

    public Long getSort(){
        return  sort;
    }

    public  String getPeopletype(){
        return  peopletype;
    }
}
